#include "mbedSPI.h"
#include "BitOrder.h"

mbedSPI::mbedSPI() :
    spi((PinName)PINS::ASR_1::SPI::MOSI,
        (PinName)PINS::ASR_1::SPI::MISO,
        (PinName)PINS::ASR_1::SPI::SCK),
    cs((PinName)PINS::ASR_1::SPI::CS,
        PINS::ASR_1::SPI::SIG::CS::DEASSERT)
{
    spi.format(
        PINS::ASR_1::SPI::NUM_BITS_PER_FRAME, //SPI_NUM_BITS_PER_FRAME,
        PINS::ASR_1::SPI::MODE_0);
    spi.frequency(PINS::ASR_1::SPI::FREQUENCY);
#if defined (TARGET_KL25Z)
    #ifndef SPI0_C1
        #define SPI0_C1 (*(uint8_t *)0x40076000)
    #endif
    SPI0_C1 |= 0x01 ; /* LSB First */
#elif defined (TARGET_TEENSY3_1)
    #define SPI0_CTAR0  ((uint32_t *)0x04002C00C)
    #define LSBFE_MASK 0x01000000
    *SPI0_CTAR0 |= LSBFE_MASK ;
#endif
}

void mbedSPI::begin()
{
}

void mbedSPI::beginSPI() /* settings are in this class */
{
    cs = PINS::ASR_1::SPI::SIG::CS::ASSERT;
    wait_us(1);
}

void mbedSPI::endSPI()
{
    cs = PINS::ASR_1::SPI::SIG::CS::DEASSERT;
}

void mbedSPI::transfer(char *bytes,int len)
{
  int i = 0;
  
  for(;i<len;++i)
  {
#if defined (TARGET_KL25Z) || (TARGET_TEENSY3_1)
    bytes[i] = spi.write(bytes[i]) ;
#else
    char c = spi.write(BitOrder::flip(bytes[i]));
    bytes[i] = BitOrder::flip(c);
#endif
  }
}