#ifndef _AFERO_COMM_HNDLR_
#define _AFERO_COMM_HNDLR_

#include "mbed.h"
//#include "pin_defines.h"
#include "mbedSPI.h"
#include "afLib.h"
#include "ToDoQ.h"
#include "Preferences.hpp"
#include "RTC_Handler.h"
#include "WatchDogWrapper.hpp"

#define ATTR_ID_SENSE_VAL 1
#define ATTR_ID_FLOW_CONTROL 4
#define ATTR_ID_SENSING_INTERVAL 3

class AferoCommHndlr
{
public:
    void loop();
    static void init();
    static AferoCommHndlr *create(mbedSPI *spi);
    void update();
    int32_t sanitizeSensingInterval(uint16_t attributeId, int32_t interval);
    Timeout *deathWish;
    static void kick_the_bucket();
    void _myOnAttributeSetComplete(const uint8_t requestId, const uint16_t attributeId, const uint16_t valueLen, const uint8_t *value);
private:
    bool _onGetTodo(ToDo *todo);
    bool _onGetTodoFalsy(ToDo *todo);
    bool (AferoCommHndlr::*_onGetTodoP)(ToDo *todo);
    bool flowControlEnabled; //ATTR_ID_FLOW_CONTROL;
    ToDoQ *todoQ;
    uint8_t sem;
    AferoCommHndlr();
    iafLib *piafLib;
    static void fco_irq_fall();
    static void myOnAttributeSet(const uint8_t requestId, const uint16_t attributeId, const uint16_t valueLen, const uint8_t *value);
    static void myOnAttributeSetComplete(const uint8_t requestId, const uint16_t attributeId, const uint16_t valueLen, const uint8_t *value);
    static bool onGetTodo(ToDo *todo);
    mbedSPI *spi;
    Timer *timer;
    Timeout *setAttrCmpDelay;
    void onSetAttrCmpDelay();
};

#endif //_AFERO_COMM_HNDLR_