#include "AferoCommHndlr.h"

static AferoCommHndlr *self = NULL;

AferoCommHndlr::AferoCommHndlr() : flowControlEnabled(false)
{
    deathWish = new Timeout();
    setAttrCmpDelay = new Timeout();
    _onGetTodoP = &AferoCommHndlr::_onGetTodo;
}

void
AferoCommHndlr::loop()
{
    piafLib->loop();
    todoQ->loop();
}

AferoCommHndlr*
AferoCommHndlr::create(mbedSPI *spi)
{
     SERIAL_PRINT_DBG("HELLO\n");
     self = new AferoCommHndlr();
     self->piafLib = iafLib::create((PinName)PINS::ASR_1::SPI::SR,
       AferoCommHndlr::fco_irq_fall,
       AferoCommHndlr::myOnAttributeSet,
       AferoCommHndlr::myOnAttributeSetComplete, spi);
     self->todoQ = ToDoQ::create(AferoCommHndlr::onGetTodo);
     SERIAL_PRINT_DBG("AferoCommHndlr init done\n");
     self->piafLib->setAttribute8(1,1) != afSUCCESS ? SERIAL_PRINT_DBG("set attr failed!!\n") : NULL ;
     
     return self;
}

void
AferoCommHndlr::myOnAttributeSet(
    const uint8_t requestId,
    const uint16_t attributeId,
    const uint16_t valueLen,
    const uint8_t *value)
{
    self->piafLib->setAttributeComplete(requestId, attributeId, valueLen, value) != afSUCCESS ? SERIAL_PRINT_DBG("set attr failed!!\n") : NULL ;
}

int32_t
AferoCommHndlr::sanitizeSensingInterval(uint16_t attributeId, int32_t interval)
{
    if(interval < 10)
    {
        interval = 10;
        self->piafLib->setAttribute32(attributeId, interval) != afSUCCESS ? SERIAL_PRINT_DBG("set attr failed!!\n") : NULL ;
    }
    return interval;
}

void
AferoCommHndlr::myOnAttributeSetComplete(
    const uint8_t requestId,
    const uint16_t attributeId,
    const uint16_t valueLen,
    const uint8_t *value)
{
    self->_myOnAttributeSetComplete(requestId,attributeId,valueLen,value);
}

void
AferoCommHndlr::_myOnAttributeSetComplete(
    const uint8_t requestId,
    const uint16_t attributeId,
    const uint16_t valueLen,
    const uint8_t *value)
{
    int32_t sensing_interval;
    char *buf = NULL;
    if(attributeId >= 4 && attributeId <= 8)
    {
        sensing_interval = *((int32_t*)value);
    }
    
    if(attributeId==2)
    {
        PREFERENCES::CRC32.ui32 = *((uint32_t*)value);
    }
    else if(attributeId==4)
    {
        buf = "PREFERENCES::SENSING_INTERVAL[SENSORS::ACCELEROMETER]";
        PREFERENCES::SENSING_INTERVAL[SENSORS::ACCELEROMETER] = sanitizeSensingInterval(attributeId,sensing_interval);
    }
    else if(attributeId==5)
    {
        buf = "PREFERENCES::SENSING_INTERVAL[SENSORS::COLOR]";
        PREFERENCES::SENSING_INTERVAL[SENSORS::COLOR] = sanitizeSensingInterval(attributeId,sensing_interval);
    }
    else if(attributeId==6)
    {
        buf = "PREFERENCES::SENSING_INTERVAL[SENSORS::PRESSURE]";
        PREFERENCES::SENSING_INTERVAL[SENSORS::PRESSURE] = sanitizeSensingInterval(attributeId,sensing_interval);
    }
    else if(attributeId==7)
    {
        buf = "PREFERENCES::SENSING_INTERVAL[SENSORS::CURRENT_TRANS]";
        PREFERENCES::SENSING_INTERVAL[SENSORS::CURRENT_TRANS] = sanitizeSensingInterval(attributeId,sensing_interval);
    }
    else if(attributeId==8)
    {
        buf = "PREFERENCES::SENSING_INTERVAL[SENSORS::TEMPERATURE]";
        PREFERENCES::SENSING_INTERVAL[SENSORS::TEMPERATURE] = sanitizeSensingInterval(attributeId,sensing_interval);
    }
    else if(attributeId==9)
    {
        SERIAL_PRINT_DBG("time stamp:%ld\n", *((uint32_t*)value));
        time_t t;
        RTC_GET_UTC(t);
        if(*((uint32_t*)value) > ((uint32_t)t))
        {
            RTC_Handler::getInstance()->setUTC(*((uint32_t*)value));
        }
    }
    else if(attributeId==1024)
    {
    }
    
    if(attributeId >= 4 && attributeId <= 8)
    {
        SERIAL_PRINT_DBG("%s=%ld\n",buf,sensing_interval);
    }
    //_onGetTodoP = &AferoCommHndlr::_onGetTodo;
    setAttrCmpDelay->attach(callback(this, &AferoCommHndlr::onSetAttrCmpDelay), 5);
}

void
AferoCommHndlr::fco_irq_fall()
{
    if(self->piafLib)
    {
        self->piafLib->mcuISR();
    }
}

bool
AferoCommHndlr::_onGetTodo(ToDo *todo)
{
    _onGetTodoP = &AferoCommHndlr::_onGetTodoFalsy;
    char buf[255];
    memset(buf,'\0',sizeof(buf));
    if(todo!=NULL)
    {
        if(PREFERENCES::FLOW_CONTROL==true)
        {
            PREFERENCES::_crc32 crc32;
            todo->toBASE64(buf,&crc32);
            if(piafLib->setAttribute(ATTR_ID_SENSE_VAL,strlen(buf),buf) != afSUCCESS)
            {
                SERIAL_PRINT_DBG("set attr failed!!\n");
                return false;
            }
            if(piafLib->setAttribute64(3,crc32.ui32) != afSUCCESS)
            {
                SERIAL_PRINT_DBG("set attr failed!!\n");
                return false;
            }
        }
        else
        {
            todo->toJSON(buf);
            int ret = afSUCCESS;
            if((ret=piafLib->setAttribute(ATTR_ID_SENSE_VAL,strlen(buf),buf)) != afSUCCESS)
            {
                SERIAL_PRINT_DBG("set attr failed!! : %d\n", ret);
                todo->error_count_inc();
                return false;
            }
            else
            {
                SERIAL_PRINT_DBG("set attr success!! : %d\n", ret);
                SERIAL_PRINT_DBG("%s\n",buf);
                todo->error_count_clear();
                return true;
            }
        }
    }
    return true;
}

bool
AferoCommHndlr::_onGetTodoFalsy(ToDo *todo)
{
    return false;
}

bool
AferoCommHndlr::onGetTodo(ToDo *todo)
{
    return (self->*(self->_onGetTodoP))(todo);
}

void
AferoCommHndlr::onSetAttrCmpDelay()
{
    SERIAL_PRINT_DBG("onSetAttrCmpDelay triggered\n");
    _onGetTodoP = &AferoCommHndlr::_onGetTodo;
}