#ifndef _TODO_QUEUE_H_
#define _TODO_QUEUE_H_

#include "mbed.h"
#include "Preferences.hpp"
#include "USQueue.hpp"
#include "Singletoned.hpp"

class ToDo;

class ToDoQ :
    public Singletoned<ToDoQ>
{
public:
    typedef bool (*onGetTodo)(ToDo*);
    static ToDoQ* create(onGetTodo);
    void loop();
    static void queuePut(ToDo*);
private:
    friend class Singletoned;
    USQueue<ToDo*> *todoQ;
    onGetTodo _onGetTodo;
    void setOnToDo(onGetTodo);
    void _queuePut(ToDo*);
    ToDoQ();
};

class ToDo
{
protected:
    int error_count;
    uint8_t serialNum;
public:
    ToDo() : retry_count(0),error_count(0),serialNum(0) {}
    int retry_count;
    virtual void toJSON(char *buf) = 0;
    virtual void getBytes(uint8_t *buf) = 0;
    virtual void toBASE64(char *buf, PREFERENCES::_crc32 *crc32)
    {
    }
    virtual void error_count_clear()
    {
        error_count = 0;
    }
    virtual void error_count_inc()
    {
        ++error_count;
    }
    virtual void success()
    {
    }
};

#endif //_TODO_QUEUE_H_