#include "ToDoQ.h"

#include "SensorsMain.hpp"

ToDoQ*
ToDoQ::create(onGetTodo callback)
{
    if(self == NULL)
    {
        self = new ToDoQ();
    }
    self->setOnToDo(callback);
    return self;
}

ToDoQ::ToDoQ()
{
    todoQ = new USQueue<ToDo*>(NULL,USQueue<ToDo*>::QSIZE_16);
}

void 
ToDoQ::setOnToDo(onGetTodo callback)
{
    _onGetTodo = callback;    
}
    
void
ToDoQ::loop()
{
    SensorsMain::getSelf()->loop();
    
    ToDo* todoP = todoQ->pkq(NULL);
    
    if(todoP != NULL)
    {
        if(_onGetTodo(todoP)!=true)
        {
            ++(todoP->retry_count);
            //todoQ->enq(todoP);
        }
        else
        {
            todoQ->deq();
            SERIAL_PRINT_DBG("ToDoQ retry count : %d\n", todoP->retry_count);
            todoP->retry_count = 0;
            todoP->success();
        }
    }
}

void
ToDoQ::_queuePut(ToDo *todo)
{
    SERIAL_PRINT_DBG("ToDoQ::_queuePut entered\n");
    todoQ->enq(todo);
}

void
ToDoQ::queuePut(ToDo *todo)
{
    ToDoQ::getSelf()->_queuePut(todo);
}