#if defined (TARGET_TEENSY3_1)
#if 0
#include "Tilt.hpp"

NAMESPACE_MARUSOLSENSORMANAGER_START

Tilt *Tilt::self = NULL;
Tilt::Tilt() : tlt_beer(PTB2, PullUp), tlt_bubble(PTB3, PullUp),
    TLT_COUNTER(100), loopTiltDelay(0), SensorCommonMembers("TAP","TILT","E",0)
{   
    initQ();
}

void
Tilt::initQ()
{
    memset(Q_newVal,EMPTY,sizeof(Q_newVal));
}

inline
void
Tilt::putQ(uint8_t oldVal, uint8_t newVal, uint16_t duration, time_t time)
{
    for (int i = 0; i < TODO_QUEUE_SIZE; i++)
    {
        SERIAL_PRINT_DBG("!!%d\n",Q_newVal[i]);
        if(Q_newVal[i] == EMPTY)
        {
            Q_newVal[i] = newVal;
            Q_oldVal[i] = oldVal;
            Q_time[i] = time;
            Q_oldValDuration[i] = oldcount;
            ToDoQ::queuePut(self);
            break;
        }
    }
}

inline
void
Tilt::getQ(uint8_t *oldVal, uint8_t *newVal, uint16_t *duration, time_t *time)
{
    for (int i = 0; i < TODO_QUEUE_SIZE; i++)
    {
        if (Q_newVal[i] != EMPTY)
        {
            *newVal = Q_newVal[i];
            *oldVal = Q_oldVal[i];
            *time = Q_time[i];
            *duration = Q_oldValDuration[i];
            Q_newVal[i]=EMPTY;
            break;
        }
    }
}

void
Tilt::read_tilt()
{
    getInstance<Tilt>()->_read_tilt();
}
    
void
Tilt::_read_tilt()
{
    oldcount++;
    if(!tlt_beer.read())
    {
        tlt_counter1 ++;
        if(tlt_counter1 > TLT_COUNTER)
        {
            tlt_counter3 = 0;
            tlt_counter2 = 0;
            newval = BEER;
        }
    }
    if(!tlt_bubble.read())
    {
        tlt_counter2 ++;
        if(tlt_counter2 > TLT_COUNTER)
        {
            tlt_counter3 = 0;
            tlt_counter1 = 0;
            newval = BUBBLE;
        }
    }
    if(tlt_beer.read() && tlt_bubble.read())
    {
        tlt_counter3 ++;
        if(tlt_counter3 > TLT_COUNTER)
        {
            tlt_counter2 = 0;
            tlt_counter1 = 0;
            newval = STOP;
        }
    }
    if(oldval != newval)
    {
        SERIAL_PRINT_DBG("!!%d->%d\n",newval,oldval);
        putQ(oldval,newval,oldcount,RTC_Handler::getInstance()->getUTC());
        oldval = newval;
        oldcount = 0;
    }
}
        
void
Tilt::toJSON(char *buf)
{
    uint8_t oldval, newval;
    uint16_t duration;
    time_t _time;
    getQ(&oldval, &newval, &duration, &_time);
    char *fmt = "{\"DEVICE\":\"%s\",\"PN\":\"%s\",\"DATA\":[{\"TIME\":\"%ld\",\"VAL\":[\"%d\"],\"UNIT\":\"%s\"}]}";
    sprintf(buf,fmt, devType, partNum, _time, newval, unit);
    SERIAL_PRINT_DBG("%s\n",buf);
}

void
Tilt::getBytes(uint8_t*)
{
}   

void
Tilt::onLoop()
{
    if(getInstance<Tilt>()->loopTiltDelay > 200)
    {
        getInstance<Tilt>()->loopTiltDelay = 0;
        getInstance<Tilt>()->read_tilt();
    }
    else
    {
        getInstance<Tilt>()->loopTiltDelay += 1;
    }
}

NAMESPACE_MARUSOLSENSORMANAGER_END
#endif
#endif //TARGET_TEENSY3_1