#ifndef _MARUSOL_SENSOR_MANAGER_TEMP_HPP_
#define _MARUSOL_SENSOR_MANAGER_TEMP_HPP_

#include "mbed.h"
#include "ToDoQ.h"
#include "RTC_Handler.h"
#include "TimeEventHandler.hpp"
#include "Singletoned.hpp"
#include "Preferences.hpp"
#include "LM75B.h"

class Temperature :
    public TimeEventHandler<Temperature>,
    public Singletoned<Temperature>,
    public ToDo
{   
    LM75B    *temp01;
    AnalogIn *temp02;
    AnalogIn *temp03;
    Temperature();
    ~Temperature();
    void go();
    friend class TimeEventHandler;
    friend class Singletoned;
    float calc(float);
    int32_t crnt_interval;
    virtual void checkIntervalUpdate();
    Timer *delta_interval;
public:
    virtual void toJSON(char*);
    virtual void getBytes(uint8_t* buf){}
    virtual void success();
};

#endif //_MARUSOL_SENSOR_MANAGER_TEMP_HPP_