#include "Temperature.hpp"

Temperature::Temperature()
{
    delta_interval = new Timer();
    temp01 = new LM75B((PinName)PINS::TEMPERATURE::SDA,(PinName)PINS::TEMPERATURE::SCL, SENSORS::NXP_LM75B::ADDRESS);
    {
        float t1;
        temp01->getTemp(&t1);
    }
    temp02 = new AnalogIn((PinName)PINS::TEMPERATURE::BEFORE_COOLING);
    temp03 = new AnalogIn((PinName)PINS::TEMPERATURE::AFTER_COOLING);
    SERIAL_PRINT_DBG("Temperature inited\n");
    read();
}

Temperature::~Temperature()
{
    delete temp01; temp01 = NULL;
    delete temp02; temp02 = NULL;
    delete temp03; temp03 = NULL;
    SERIAL_PRINT_DBG("Temperature de-inited\n");
}

float
Temperature::calc(float f)
{
    float raw = f * 3.3;
    float rr1,t;
    
    float& R1 = SENSORS::SEMITEC_502AT_11::R1;
    float& R0 = SENSORS::SEMITEC_502AT_11::R0;
    float& B  = SENSORS::SEMITEC_502AT_11::B;
    float& T0 = SENSORS::SEMITEC_502AT_11::T0;

    rr1= R1  * raw / (3.3 - raw);
    t = 1 / (log(rr1 / R0) / B + (1 / T0));
    return (t - 273.15);
}

void
Temperature::checkIntervalUpdate()
{
    if( interval_current != PREFERENCES::SENSING_INTERVAL[SENSORS::TEMPERATURE])
    {
        timeout->detach();
        backToNOP();
        interval_current = PREFERENCES::SENSING_INTERVAL[SENSORS::TEMPERATURE];
        timeout->attach(callback(this, &Temperature::read), interval_current);
    }
}

void
Temperature::go()
{
    backToNOP();
    delta_interval->reset();
    ToDoQ::queuePut(this);
    delta_interval->start();
}

void
Temperature::success()
{
    ++serialNum;
    int32_t delta = (int32_t)delta_interval->read();
    int32_t def_interval = PREFERENCES::SENSING_INTERVAL[SENSORS::TEMPERATURE];
    timeout->attach(callback(this, &Temperature::read), def_interval < delta ? def_interval : def_interval - delta );
    delta_interval->stop();
}

void
Temperature::toJSON(char* buf)
{
    char* fmt  = "{\"DEVICE\":\"TEMP04\",\"VAL_1\":\"%.1f\",\"VAL_2\":\"%.1f\",\"VAL_3\":\"%.1f\",\"S\":\"%d\",\"E\":\"%d\"}";
    float t1;
    temp01->getTemp(&t1);
    sprintf(
        buf,
        fmt,
        t1,
        calc(temp02->read()),
        calc(temp03->read()),
        serialNum,
        error_count
    );
}
