#include "SensorsMain.hpp"

#include "ToDoQ.h"

SensorsMain::SensorsMain()
{
    read();
}

void
SensorsMain::go()
{
#if defined (TARGET_KL25Z)
    SENSORS::ACTIVE[SENSORS::COLOR] == true ? Color_VEML6040::getSelf()->loop() : 0;
    SENSORS::ACTIVE[SENSORS::TEMPERATURE] == true ? Temperature::getSelf()->loop() : 0;
    SENSORS::ACTIVE[SENSORS::ACCELEROMETER] == true ? Accelerometer_Sekisan::getSelf()->loop() : 0;
    SENSORS::ACTIVE[SENSORS::CURRENT_TRANS] == true ? CurrentTrans::getSelf()->loop() : 0;
    if(SENSORS::ACTIVE[SENSORS::PRESSURE] == true)
    {
        GasPressure::getSelf()->loop();
        LiquidPressure::getSelf()->loop();
    }
    //SERIAL_PRINT_DBG_FUNCNAME();
#elif defined (TARGET_TEENSY3_1)
    SENSORS::ACTIVE[SENSORS::ACCELEROMETER] == true ? Accelerometer::getInstance()->loop() : Accelerometer::deleteInstance();
#endif
}
