#ifndef _LIQUID_PERSSURE_H_
#define _LIQUID_PERSSURE_H_

#if defined (__MBED__)
#include "mbed.h"
#endif
#include "ToDoQ.h"
#include "Preferences.hpp"
#include "TimeEventHandler.hpp"
#include "Singletoned.hpp"
#include "RTC_Handler.h"

class LiquidPressure :
    public ToDo,
    public TimeEventHandler<LiquidPressure>,
    public Singletoned<LiquidPressure>
{
    LiquidPressure();
    ~LiquidPressure();
    float calc();
    float val;
    AnalogIn *ain;
    void go();
public:
    friend class TimeEventHandler;
    friend class Singletoned;
    virtual void toJSON(char*);
    virtual void getBytes(uint8_t*);
};

#endif //_LIQUID_PERSSURE_H_