#include "LiquidPressure.hpp"

LiquidPressure::LiquidPressure()
{
    ain = new AnalogIn((PinName)PINS::LIQUID::AIN);
    read();
}

LiquidPressure::~LiquidPressure()
{
   delete ain;
   ain = NULL;
}

float LiquidPressure::calc()
{
    SERIAL_PRINT_DBG_FUNCNAME();
     float &v_ref = SENSORS::GP_M010_KEYENCE::V_REF;
     float &shut_r = SENSORS::GP_M010_KEYENCE::SHUNT_R;
     float &lowest_cur = SENSORS::GP_M010_KEYENCE::LOWEST_CUR;
     float &pressure_coef = SENSORS::GP_M010_KEYENCE::PRESSURE_COEF;
     float &val = packet.pressure.val;
     float ret;
     short ret_s;
     ret = (v_ref * val / shut_r - lowest_cur) * pressure_coef;
     ret_s = ret *= 4096;
     ret /= ret_s / 4096;
     return ret < 0 ? 0 : ret;
}

void LiquidPressure::toJSON(char* buf)
{
    char* &fmt = SENSORS::GP_M010_KEYENCE::JSON_FMT;
    char* &type = SENSORS::GP_M010_KEYENCE::TYPE;
    char* &pn = SENSORS::GP_M010_KEYENCE::PN;
    char* &unit = SENSORS::GP_M010_KEYENCE::UNIT;
SERIAL_PRINT_DBG_FUNCNAME();
    time_t &time = packet.pressure.timeStamp;
SERIAL_PRINT_DBG_FUNCNAME();
    float f = calc();
SERIAL_PRINT_DBG("%f\n", f);
//      sprintf(buf,fmt,type,pn,time,f,unit);
    sprintf(buf,fmt,type,pn,f);
}

void LiquidPressure::getBytes(uint8_t*)
{
}

void
LiquidPressure::go()
{
    SERIAL_PRINT_DBG_FUNCNAME();
    timeout->attach(callback(this,&LiquidPressure::read), PREFERENCES::SENSING_INTERVAL[SENSORS::PRESSURE]);
    packet.pressure.val = ain->read();
    SERIAL_PRINT_DBG_FUNCNAME();
    RTC_GET_UTC(packet.pressure.timeStamp);
    ToDoQ::queuePut(this);
    backToNOP();
}