#ifndef _GAS_PRESSURE_H_
#define _GAS_PRESSURE_H_

#if defined (__MBED__)
    #include "mbed.h"
#endif
#include "ToDoQ.h"
#include "Preferences.hpp"
#include "TimeEventHandler.hpp"
#include "Singletoned.hpp"
#include "RTC_Handler.h"

class GasPressure :
    public ToDo,
    public TimeEventHandler<GasPressure>,
    public Singletoned<GasPressure>
{
    GasPressure();
    ~GasPressure();
    float calc();
    float val;
    AnalogIn *ain;
    void go();
public:
    friend class TimeEventHandler;
    friend class Singletoned;
    virtual void toJSON(char*);
    virtual void getBytes(uint8_t*);
};

#endif //_GAS_PRESSURE_H_