#include "GasPressure.hpp"

GasPressure::GasPressure()
{
    ain = new AnalogIn((PinName)PINS::GAS::AIN);
    read();
}

GasPressure::~GasPressure()
{
   delete ain;
   ain = NULL;
}

float
GasPressure::calc()
{
SERIAL_PRINT_DBG_FUNCNAME();
     float &v_ref = SENSORS::AP_53A_KEYENCE::V_REF;
     float &shut_r = SENSORS::AP_53A_KEYENCE::SHUNT_R;
     float &lowest_cur = SENSORS::AP_53A_KEYENCE::LOWEST_CUR;
     float &pressure_coef = SENSORS::AP_53A_KEYENCE::PRESSURE_COEF;
     float &val = packet.pressure.val;
     float ret;
     short ret_s;
     ret = (v_ref * val / shut_r - lowest_cur) * pressure_coef;
     ret_s = ret *= 4096;
     ret /= ret_s / 4096;
     return ret < 0 ? 0 : ret;
}

void
GasPressure::toJSON(char* buf)
{
    char* &fmt = SENSORS::AP_53A_KEYENCE::JSON_FMT;
    char* &type = SENSORS::AP_53A_KEYENCE::TYPE;
    char* &pn = SENSORS::AP_53A_KEYENCE::PN;
    char* &unit = SENSORS::AP_53A_KEYENCE::UNIT;
SERIAL_PRINT_DBG_FUNCNAME();
    time_t &time = packet.pressure.timeStamp;
SERIAL_PRINT_DBG_FUNCNAME();
    float f = calc();
SERIAL_PRINT_DBG("%f\n", f);
//      sprintf(buf,fmt,type,pn,time,f,unit);
    sprintf(buf,fmt,type,pn,f);
}

void
GasPressure::getBytes(uint8_t*)
{
}

void
GasPressure::go()
{
    SERIAL_PRINT_DBG_FUNCNAME();
    timeout->attach(callback(this, &GasPressure::read), PREFERENCES::SENSING_INTERVAL[SENSORS::PRESSURE]);
    packet.pressure.val = ain->read();
    SERIAL_PRINT_DBG_FUNCNAME();
    RTC_GET_UTC(packet.pressure.timeStamp);
    ToDoQ::queuePut(this);
    backToNOP();
}