#include "CurrentTrans.hpp"

CurrentTrans::CurrentTrans()
{
    m_Ain = new AnalogIn((PinName)PINS::CURRENT_TRANS::AIN);
    read();
}

CurrentTrans::~CurrentTrans()
{
    delete m_Ain;
    m_Ain = NULL;
}

void
CurrentTrans::toJSON(char *buf)
{
    char* &fmt  = SENSORS::SR_3702_150N_14Z::JSON_FMT;
    char* &type = SENSORS::SR_3702_150N_14Z::TYPE;
    char* &pn   = SENSORS::SR_3702_150N_14Z::PN;
    char* &unit = SENSORS::SR_3702_150N_14Z::UNIT;
    sprintf(buf, fmt, type, pn, 
        RTC_GET_UTC(packet.temperature.timeStamp),
        packet.current_trans.val,
        unit);
    SERIAL_PRINT_DBG("%s\n",buf);
}

void
CurrentTrans::getBytes(uint8_t *buf)
{
}

void
CurrentTrans::go()
{
    timeout->attach(this, &CurrentTrans::read, PREFERENCES::SENSING_INTERVAL[SENSORS::CURRENT_TRANS]);
    packet.current_trans.val = m_Ain->read();
    RTC_GET_UTC(packet.current_trans.timeStamp);
    ToDoQ::queuePut(this);
    backToNOP();
}