#ifndef _MARUSOL_SENSOR_MANAGER_COLOR_VEML_6040_H_
#define _MARUSOL_SENSOR_MANAGER_COLOR_VEML_6040_H_

#include "mbed.h"
#include "VEML6040.h"
#include "ToDoQ.h"
#include "RTC_Handler.h"
#include "TimeEventHandler.hpp"
#include "Singletoned.hpp"
#include "MCUResetReason.hpp"
#include "WatchDogWrapper.hpp"

class Color_VEML6040 :
    public ToDo,
    public TimeEventHandler<Color_VEML6040>,
    public Singletoned<Color_VEML6040>
{
    Timer *LED_Timer;
    Color_VEML6040();
    ~Color_VEML6040();
    VEML6040 *m_veml6040;
    PwmOut *LEDs[3];
    void doLEDs(uint8_t R, uint8_t G, uint8_t B);
    void doLEDs_ui16(uint16_t R, uint16_t G, uint16_t B);
    void gogo();
    void go();
    void (Color_VEML6040::*callbackLED)();
    void prepare_LED();
    void registerForUpdate();
    int32_t AHEAD_OF_TIME;
    class ResetSignal : public ToDo
    {
        bool bikkuri;
    public:
        ResetSignal();
        virtual void toJSON(char* buf);
        virtual void getBytes(uint8_t*);
    };
    ResetSignal rSignal;
    virtual void checkIntervalUpdate();
    struct CountDownToSystemReset :
        public Singletoned<CountDownToSystemReset>
    {
        int count;
    public:
        friend class SignleToned;
        static void create(int count)
        {
            if(self != NULL)
            {
                delete self;
            }
            self = new CountDownToSystemReset(count);
        }
        CountDownToSystemReset(int count = 10)
        {
            this->count = count;
        }
        void countDown()
        {
            --count;
            if(count<=0)
            {
                WatchDogWrapper::getSelf()->kick_the_bucket();
                count=0;
            }
        }
    };
public:
    friend class TimeEventHandler;
    friend class Singletoned;
    virtual void toJSON(char*);
    virtual void getBytes(uint8_t*);
    virtual void success();
};

#endif //_MARUSOL_SENSOR_MANAGER_COLOR_VEML_6040_H_