#include "Color_VEML6040.hpp"

/* following 2 lines were added by Motoo Tanaka on 18-Oct-2017 */
#define AF_BIT   0x02
#define TRIG_BIT 0x04

Color_VEML6040::Color_VEML6040()
{
    CountDownToSystemReset::create(2);
    LED_Timer = new Timer();
    AHEAD_OF_TIME = 1;
    LEDs[0] = new PwmOut((PinName)PINS::LED_4_COLOR::R) ;
    LEDs[1] = new PwmOut((PinName)PINS::LED_4_COLOR::G) ;
    LEDs[2] = new PwmOut((PinName)PINS::LED_4_COLOR::B) ;
    LEDs[0]->write(1.0) ;
    LEDs[1]->write(1.0) ;
    LEDs[2]->write(1.0) ;
    LEDs[0]->period_us(200) ; /* pwm period 200us */
    LEDs[1]->period_us(200) ; /* pwm period 200us */
    LEDs[2]->period_us(200) ; /* pwm period 200us */
    m_veml6040 = new VEML6040((PinName)PINS::COLOR::SDA, (PinName)PINS::COLOR::SCL, SENSORS::VEML6040::ADDRESS);
    m_veml6040->setCOLORConf(0x00) ; /* default setting */
    callbackLED = &Color_VEML6040::prepare_LED;
    int i = 0;
    for(;i<3;++i)
    {
        ToDoQ::queuePut(&rSignal);
    }
    read();
    //interval_current = -1;
}
   
Color_VEML6040::~Color_VEML6040()
{
    delete LEDs[0];
    LEDs[0] = NULL;
    delete LEDs[1];
    LEDs[1] = NULL;
    delete LEDs[2];
    LEDs[2] = NULL;
    delete m_veml6040;
    m_veml6040 = NULL;
}

void
Color_VEML6040::checkIntervalUpdate()
{
    if( interval_current != PREFERENCES::SENSING_INTERVAL[SENSORS::COLOR])
    {
        timeout->detach();
        backToNOP();
        callbackLED = &Color_VEML6040::prepare_LED;
        interval_current = PREFERENCES::SENSING_INTERVAL[SENSORS::COLOR];
        int32_t time = interval_current <= 10 ? 10 : interval_current - AHEAD_OF_TIME;
        timeout->attach( callback( this, &Color_VEML6040::read), time );
        SERIAL_PRINT_DBG("Color sensing interval updated : %d sec \n", time);
    }
}

void
Color_VEML6040::toJSON(char *buf)
{
    if(
        m_veml6040->getRData(&packet.color.R) ||
        m_veml6040->getGData(&packet.color.G) ||
        m_veml6040->getBData(&packet.color.B) )
    {
        CountDownToSystemReset::getSelf()->countDown();
        char *fmt = "{\"DEVICE\":\"COLOR\",\"PN\":\"VEML6040\",\"VAL_R\":\"##\",\"VAL_G\":\"##\",\"VAL_B\":\"##\",\"UNIT\":\"mW/cm2\",\"S\":\"%d\",\"E\":\"%d\"}";
        sprintf(buf,fmt,serialNum,error_count);
    }
    else
    {
        SERIAL_PRINT_DBG("RGB values read %.3f sec after LEDs are turned on\n", LED_Timer->read());
        char* &fmt = SENSORS::VEML6040::JSON_FMT;
        uint16_t &r = packet.color.R;
        uint16_t &g = packet.color.G;
        uint16_t &b = packet.color.B;
        sprintf(buf,fmt,r,g,b,serialNum,error_count);
    }
}

void
Color_VEML6040::success()
{
    doLEDs_ui16(0,0,0);
    SERIAL_PRINT_DBG("LED:TURNED OFF.\n");
    ++serialNum;
    callbackLED = &Color_VEML6040::prepare_LED;
    int32_t delta = (int32_t)(LED_Timer->read());
    LED_Timer->stop();
    LED_Timer->reset();
    timeout->attach(callback(this, &Color_VEML6040::read), interval_current < delta ? interval_current : (interval_current - delta) );
}

Color_VEML6040::ResetSignal::ResetSignal()
{
    bikkuri = true;
}

void
Color_VEML6040::ResetSignal::toJSON(char *buf)
{
    char *str;
    
    if(bikkuri==true)
    {
        bikkuri = false;
        str = "{\"DEVICE\":\"COLOR\",\"PN\":\"VEML6040\",\"VAL_R\":\"%s\",\"VAL_G\":\"!!\",\"VAL_B\":\"!!\",\"UNIT\":\"!!\"}";
    } else {
        bikkuri = true;
        str = "{\"DEVICE\":\"COLOR\",\"PN\":\"VEML6040\",\"VAL_R\":\"%s\",\"VAL_G\":\"**\",\"VAL_B\":\"**\",\"UNIT\":\"**\"}";
    }
    
    sprintf(
        buf,
        str,
        MCUResetReason::ref()->getResetReasonStr());
}

void
Color_VEML6040::ResetSignal::getBytes(uint8_t *buf)
{
}
    
void
Color_VEML6040::getBytes(uint8_t *buf)
{
    
}
       
void
Color_VEML6040::doLEDs(uint8_t R, uint8_t G, uint8_t B)
{
    float fr, fg, fb ;
    fr = (float)(255-R)/255.0 ;
    fg = (float)(255-G)/255.0 ;
    fb = (float)(255-B)/255.0 ;
    LEDs[0]->write(fr) ;
    LEDs[1]->write(fg) ;
    LEDs[2]->write(fb) ;
}

void
Color_VEML6040::doLEDs_ui16(uint16_t R, uint16_t G, uint16_t B)
{
    float fr, fg, fb ;
    fr = (float)(65535-R)/65535.0;
    fg = (float)(65535-G)/65535.0;
    fb = (float)(65535-B)/65535.0;
    LEDs[0]->write(fr) ;
    LEDs[1]->write(fg) ;
    LEDs[2]->write(fb) ;
}
       
void
Color_VEML6040::prepare_LED()
{
    timeout->attach(callback(this,&Color_VEML6040::read),AHEAD_OF_TIME);
    callbackLED = &Color_VEML6040::registerForUpdate; //read_sensor_and_turn_off_LED;
    doLEDs_ui16(
        SENSORS::VEML6040::PWM_LED_R_UI16,
        SENSORS::VEML6040::PWM_LED_G_UI16,
        SENSORS::VEML6040::PWM_LED_B_UI16);
    m_veml6040->setCOLORConf(AF_BIT | TRIG_BIT) ; /* Force mode with Trigger */
    SERIAL_PRINT_DBG("LED:TURNED ON. Timer start\n");
    LED_Timer->start();
}

void
Color_VEML6040::registerForUpdate()
{
    ToDoQ::queuePut(this);
}

void
Color_VEML6040::go()
{
    (this->*callbackLED)();
    backToNOP();
}