#ifndef _ASYMMETRICAL_FIFO_HPP_
#define _ASYMMETRICAL_FIFO_HPP_

#include "mbed.h"
#include "Preferences.hpp"
#include "TimeEventHandler.hpp"
#include "Accelerometer.hpp"
#include "CheckSum.h"
#include "base64.h"

#include <queue>

using namespace std;

namespace MaruSolSensorManager
{
    class AsymFIFO
    {
        struct RECORD;
        queue<RECORD*> q_record;
        queue<char*> q_records;
        CheckSum *checkSum;
        struct RECORD
        {
            RECORD(time_t time, int16_t x, int16_t y, int16_t z)
            {
                this->data.time = time;
                this->data.x = x;
                this->data.y = y;
                this->data.z = z;
            }
            union
            {
                struct
                {
                    int16_t x,y,z, dummy;
                    time_t time;
                } data;
                uint8_t bytes[12];
            };
        };
        uint32_t NUM_MAX_RECORD_Q;
    public:
        AsymFIFO()
        {
            checkSum = new CheckSum();
            NUM_MAX_RECORD_Q = 6;
        }
        uint32_t buffed()
        {
            return q_records.size();
        }
        void push(time_t time, short x, short y, short z)
        {
            RECORD *record = new RECORD(time,x,y,z);
                        
            q_record.push(record);
            
            if(q_record.size()>=NUM_MAX_RECORD_Q)
            {
                char *pRecords = new char[sizeof(RECORD)*NUM_MAX_RECORD_Q];
                memset(pRecords,'\0',sizeof(RECORD)*NUM_MAX_RECORD_Q);
                SERIAL_PRINT_DBG_FUNCNAME();
                char *pRecords_crnt = pRecords;
                while(q_record.size()>0)
                {
                    RECORD *rec = q_record.front();
                    memcpy(pRecords_crnt, rec->bytes, sizeof(rec->bytes));
                    delete rec;
                    rec = NULL;
                    q_record.pop();
                    pRecords_crnt += sizeof(RECORD);
                }
                q_records.push(pRecords);
SERIAL_PRINT_DBG("q_records.size=%d\n",q_records.size());
                if(q_records.size()>=100)
                {
SERIAL_PRINT_DBG("Exceeded records number +100.  Drop the last record\n");
                    char *lastRecords = q_records.front();
                    q_records.pop();
                    delete[] lastRecords;
                    lastRecords = NULL;
                }
            }
        }
        void pop(uint8_t *buf, PREFERENCES::_crc32 *crc32)
        {
            char *p = NULL;
            p = q_records.front();
            checkSum->reset();
            checkSum->calc((uint8_t*)p,sizeof(RECORD)*NUM_MAX_RECORD_Q);
            PREFERENCES::_crc32 fCRC32 = checkSum->get();
SERIAL_PRINT_DBG("crc32 old:%08X new:%08X\n",PREFERENCES::CRC32.ui32, fCRC32.ui32);
            if(PREFERENCES::CRC32.ui32 == fCRC32.ui32)
            {
                q_records.pop();
                delete[] p;
                p = q_records.front();
                checkSum->calc((uint8_t*)p,sizeof(RECORD)*NUM_MAX_RECORD_Q);
                fCRC32 = checkSum->get();
            }
            crc32->ui32 =
            fCRC32.ui32;
            uint8_t* workSpace = new uint8_t[255];
            memset(workSpace,0,255);
            memcpy(workSpace, p, sizeof(RECORD)*NUM_MAX_RECORD_Q);
            memcpy(workSpace + sizeof(RECORD)*NUM_MAX_RECORD_Q, fCRC32.ui8, sizeof(fCRC32));
//            for(uint32_t i = 0; i < 255; ++i)
//            {
//SERIAL_PRINT_DBG("%02X-",workSpace[i]);
//            }
            size_t olen;
            size_t src_size = sizeof(RECORD)*NUM_MAX_RECORD_Q+sizeof(fCRC32);
//SERIAL_PRINT_DBG("src_size=%d\n",src_size);            
            mbedtls_base64_encode(buf, 255, &olen, workSpace,src_size);
            delete[] workSpace;
        }
    };
};

#endif //_MARUSOL_SENSOR_MANAGER_TEMP_H_