#ifndef _ACCELEROMETER_SEKISAN_HPP_
#define _ACCELEROMETER_SEKISAN_HPP_

#include "mbed.h"
#include "ToDoQ.h"
#include "RTC_Handler.h"
#include "MMA8451Q.h"
#include "WakeUp.h"
#include "Preferences.hpp"
#include "TimeEventHandler.hpp"
#include "Singletoned.hpp"
#include "MCUResetReason.hpp"

class Accelerometer_Sekisan :
    public ToDo,
    public TimeEventHandler<Accelerometer_Sekisan>,
    public Singletoned<Accelerometer_Sekisan>
{
    MMA8451Q *acc;
    Accelerometer_Sekisan();
    ~Accelerometer_Sekisan();
    void go();
    virtual void checkIntervalUpdate();
    float read_count;
    void (Accelerometer_Sekisan::*ptr_to_go)();
    void go_NormalOperation();
    void go_WhileWaitingForSuccess();
    void readSensorAndIncCount();
    float sensing_interval;
    class SekisanCounter
    {
        friend Accelerometer_Sekisan;
        int32_t sekisanchi;
        uint16_t sampling_count;
        uint32_t sampling_interval;
        int32_t prev_x, prev_y, prev_z;
    public:
        SekisanCounter();
        inline uint32_t get_sampling_interval()
        {
            return sampling_interval;
        }
        void push(int32_t, int32_t, int32_t);
        int32_t pop();
    };
    SekisanCounter *sekisan_counter;
public:
    friend class TimeEventHandler;
    friend class Singletoned;
    virtual void toJSON(char*);
    virtual void getBytes(uint8_t*){}
    virtual void toBASE64(char *buf, PREFERENCES::_crc32 *crc32){}
    virtual void success();
};

#endif //_MARUSOL_SENSOR_MANAGER_TEMP_H_