#include "Accelerometer_Sekisan.hpp"

Accelerometer_Sekisan::Accelerometer_Sekisan()
{
    sensing_interval = 0.1;
    read_count = 0;
    acc = new MMA8451Q(
        (PinName)PINS::ACCELEROMETER::SDA,
        (PinName)PINS::ACCELEROMETER::SCL,
        SENSORS::MMA8451Q::ADDRESS);
    interval_current = PREFERENCES::SENSING_INTERVAL[SENSORS::ACCELEROMETER];
    sekisan_counter = new SekisanCounter();
    ptr_to_go = &Accelerometer_Sekisan::go_NormalOperation;
    read();
}
    
Accelerometer_Sekisan::~Accelerometer_Sekisan()
{
    delete acc;
    acc = NULL;
    SERIAL_PRINT_DBG("Accelerometer_Sekisan inited\n");
}

void
Accelerometer_Sekisan::toJSON(char *buf)
{
    char* &fmt = SENSORS::MMA8451Q::JSON_FMT;
    float temp_sekisanchi = sekisan_counter->sekisanchi/4096;
    int temp_sampling_count = sekisan_counter->sampling_count;
    float f = sekisan_counter->pop();
    f /= 4096;
    sprintf( buf, fmt, f,serialNum++,error_count);
    SERIAL_PRINT_DBG("Accelerometer_Sekisan %0.03f = %0.03f / %d\n",
        f,
        temp_sekisanchi,
        temp_sampling_count);
}

void
Accelerometer_Sekisan::go()
{
    backToNOP();
    (this->*ptr_to_go)();
}

void
Accelerometer_Sekisan::go_NormalOperation()
{
    if(read_count >= interval_current)
    {
        ptr_to_go = &Accelerometer_Sekisan::go_WhileWaitingForSuccess;
        read_count = 0;
        ToDoQ::queuePut(this);
    }
    else
    {
        readSensorAndIncCount();
    }
    timeout->attach(this, &Accelerometer_Sekisan::read, sensing_interval);
}

void
Accelerometer_Sekisan::go_WhileWaitingForSuccess()
{
    readSensorAndIncCount();
    timeout->attach(this, &Accelerometer_Sekisan::read, sensing_interval);
}

void
Accelerometer_Sekisan::success()
{
    ptr_to_go = &Accelerometer_Sekisan::go_NormalOperation;
}

void
Accelerometer_Sekisan::readSensorAndIncCount()
{
    read_count += sensing_interval;
    sekisan_counter->push(
        acc->getAccX()*4096,
        acc->getAccY()*4096,
        acc->getAccZ()*4096);
}

void
Accelerometer_Sekisan::checkIntervalUpdate()
{
    if( interval_current != PREFERENCES::SENSING_INTERVAL[SENSORS::ACCELEROMETER])
    {
        interval_current = PREFERENCES::SENSING_INTERVAL[SENSORS::ACCELEROMETER];
    }
}

Accelerometer_Sekisan::SekisanCounter::SekisanCounter()
{
    sampling_count = 0;
    sampling_interval = 10;
    sekisanchi = 0;
    prev_x = 0;
    prev_y = 0;
    prev_z = 0;
}

void Accelerometer_Sekisan::SekisanCounter::push(int32_t x, int32_t y, int32_t z)
{
    int32_t _x, _y, _z;

    ++sampling_count;
    _x = abs(prev_x - x);
    _y = abs(prev_y - y);
    _z = abs(prev_z - z);        
    
    sekisanchi += (_x + _y + _z);
    prev_x = x;
    prev_y = y;
    prev_z = z;
}

int32_t Accelerometer_Sekisan::SekisanCounter::pop()
{
    int32_t ret = (sampling_count == 0) ? 1 : sekisanchi / (sampling_count);
    sekisanchi = 0;
    sampling_count = 0;
    return ret;
}