#ifndef _ACCELEROMETER_HPP_
#define _ACCELEROMETER_HPP_

#include "mbed.h"
#include "ToDoQ.h"
#include "RTC_Handler.h"
#include "MMA8451Q.h"
#include "WakeUp.h"
#include "Preferences.hpp"
#include "TimeEventHandler.hpp"
#include "AsymFIFO.hpp"

namespace MaruSolSensorManager
{
    class Accelerometer : public ToDo, public TimeEventHandler<Accelerometer>
    {
        MMA8451Q *acc;
        Accelerometer();
        ~Accelerometer();
        void go();
        AsymFIFO *pAsymFIFO;
        int32_t read_count;
        PACKET packet_prev;
    public:
        friend class TimeEventHandler;
        virtual void toJSON(char*);
        virtual void getBytes(uint8_t*);
        virtual void toBASE64(char *buf, PREFERENCES::_crc32 *crc32);
    };
};

#endif //_MARUSOL_SENSOR_MANAGER_TEMP_H_