#include "Accelerometer.hpp"

namespace MaruSolSensorManager
{
    Accelerometer::Accelerometer()
    {
        read_count = 1;
        acc = new MMA8451Q(
            (PinName)PINS::ACCELEROMETER::SDA,
            (PinName)PINS::ACCELEROMETER::SCL,
            SENSORS::MMA8451Q::ADDRESS);
        
        pAsymFIFO = new AsymFIFO();
        
        packet_prev.accelerometer.x = 0;
        packet_prev.accelerometer.y = 0;
        packet_prev.accelerometer.z = 0;
        
        read();
    }
    
    Accelerometer::~Accelerometer()
    {
        delete acc;
        acc = NULL;
        SERIAL_PRINT_DBG("Accelerometer inited\n");
    }

    void
    Accelerometer::toJSON(char *buf)
    {
        float x = packet.accelerometer.x;
        float y = packet.accelerometer.y;
        float z = packet.accelerometer.z;

        if(SENSORS::DELTA[SENSORS::ACCELEROMETER]==true)
        {
            x = abs(packet_prev.accelerometer.x - packet.accelerometer.x);
            y = abs(packet_prev.accelerometer.y - packet.accelerometer.y);
            z = abs(packet_prev.accelerometer.z - packet.accelerometer.z);
            packet_prev.accelerometer.x = packet.accelerometer.x;
            packet_prev.accelerometer.y = packet.accelerometer.y;
            packet_prev.accelerometer.z = packet.accelerometer.z;
        }
        x /= 4096;
        y /= 4096;
        z /= 4096;
        char* &fmt = SENSORS::MMA8451Q::JSON_FMT;
        sprintf( buf, fmt, x, y, z );
    }
        
    void
    Accelerometer::getBytes(uint8_t *buf)
    {
        memcpy(buf,(uint8_t*)&packet.accelerometer,sizeof(packet.accelerometer));
    }
    
    void
    Accelerometer::toBASE64(char *buf, PREFERENCES::_crc32 *crc32)
    {
        pAsymFIFO->pop((uint8_t*)buf, crc32);
    }
    
    void
    Accelerometer::go()
    {
        timeout->attach(this, &Accelerometer::read, 1);
        if(read_count>=(PREFERENCES::SENSING_INTERVAL[SENSORS::ACCELEROMETER]))
        {
            read_count = 1;
            packet.accelerometer.x = acc->getAccX()*4096;
            packet.accelerometer.y = acc->getAccY()*4096;
            packet.accelerometer.z = acc->getAccZ()*4096;
            RTC_GET_UTC(packet.accelerometer.timeStamp);
            if(PREFERENCES::FLOW_CONTROL==true)
            {
                pAsymFIFO->push(
                    packet.accelerometer.timeStamp,
                    packet.accelerometer.x,
                    packet.accelerometer.y,
                    packet.accelerometer.z);
            }
            else
            {
                ToDoQ::queuePut(this);
            }
        }
        else
        {
            ++read_count;
        }
        
        if(pAsymFIFO->buffed()>1)
        {
            ToDoQ::queuePut(this);
        }
        backToNOP();
    }
};