#include "mbed.h"
#include "AferoCommHndlr.h"
//#include "pin_defines.h"
#include "RTC_Handler.h"
#include "Preferences.hpp"
#include "WakeUp.h"
#include "DebugIO.hpp"
#include "WatchDogWrapper.hpp"
#include "MCUResetReason.hpp"

int
main()
{
    WakeUp::calibrate();
    wait_ms(500);
#if defined(TARGET_KL25Z)
    WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z
    DebugIO::init();
    DebugIO::test();
    mbedSPI mbedspi;
    DigitalOut ASR1Reset(
        (PinName)PINS::ASR_1::RESET,
        PINS::ASR_1::SIG::RESET::DEASSERT);
    ASR1Reset = PINS::ASR_1::SIG::RESET::ASSERT;
    wait_ms(300);
#if defined(TARGET_KL25Z)
    WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z
    wait_ms(300);
#if defined(TARGET_KL25Z)
    WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z
    wait_ms(300);
#if defined(TARGET_KL25Z)
    WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z
    ASR1Reset = PINS::ASR_1::SIG::RESET::DEASSERT;
    wait_ms(300);
#if defined(TARGET_KL25Z)
    WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z
    wait_ms(300);
#if defined(TARGET_KL25Z)
    WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z
    wait_ms(300);
#if defined(TARGET_KL25Z)
    WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z

    SERIAL_PRINT_DBG("reset reason: %s\n",MCUResetReason::ref()->getResetReasonStr());

    AferoCommHndlr *aHnd = AferoCommHndlr::create(&mbedspi);
    
    while(1) {
#if defined(TARGET_KL25Z)
        WatchDogWrapper::getSelf()->reset();
#endif //TARGET_KL25Z
        aHnd->loop();
    }
}
