#include "mbed.h"
#include "SpaceBall.h"

PwmOut led[] = {(LED1), (LED2), (LED3), (LED4) };
SpaceBall SBall(p9, p10, true);   // tx, rx, bSOrb
Serial pc(USBTX, USBRX);   // tx, rx
Timer t;

int main() {
    t.start();
    pc.baud(460800);
    pc.printf ( "SpaceBall Test\r\n\r\n" );
    
    SBall.Init();
    
    while(1) {

        led[0] = abs( SBall[TX] ) + abs( SBall[TY] ) + abs( SBall[TZ] );
        led[1] = abs( SBall[RX] );
        led[2] = abs( SBall[RY] );
        led[3] = abs( SBall[RZ] );
    
        if ( t.read_ms() > 1000 )
        {
            t.reset();
            t.start();
            //myled = !myled;
            
            pc.printf ( "SBall: %5d %5d %5d   %5d %5d %5d   %04X\r\n",
                SBall.GetAxisRaw(0),
                SBall.GetAxisRaw(1),
                SBall.GetAxisRaw(2),
                SBall.GetAxisRaw(3),
                SBall.GetAxisRaw(4),
                SBall.GetAxisRaw(5),
                SBall.GetButtons() );
        }
        
        wait_us(500);
    }
}
