#include "SpaceBall.h"

#define Sleep(x) wait_ms(x*10)
//extern Serial pc;

///////////////////////////////////////////////////////////////////////////////

SpaceBall::SpaceBall ( PinName tx, PinName rx, bool bSpaceOrb ) : _serial ( tx, rx )
{
    _bSpaceOrb = bSpaceOrb;
    _serial.baud ( 9600 );
    
    _fScale = 1.0f;

    _axis[0]       = 0;      /* last translational data received */
    _axis[1]       = 0;
    _axis[2]       = 0;
    _axis[3]       = 0;        /* last rotational data received */
    _axis[4]       = 0;
    _axis[5]       = 0;
    _buttons       = 0;       /* current button status */

    _data[0]        = 0;
    m_erroroccured  = 0;  /* if set, we've received an error packet or packets */
    m_resetoccured  = 0;  /* if set, ball was reset, so have to reinitialize it */
    m_spaceball4000 = 0; /* if set, its a Spaceball 4000 */
    m_leftymode4000 = 0; /* if set, Spaceball 4000 in "lefty" orientation */

    _mapping = 1;
    _escape = false;
    _idx = 0;
    
    _serial.attach ( this, &SpaceBall::SerialISR );

    //Init();  
    
};

///////////////////////////////////////////////////////////////////////////////

void SpaceBall::Init()
{
    if ( _bSpaceOrb )
        InitSO ();
    else
        InitSB ();
}

///////////////////////////////////////////////////////////////////////////////

void SpaceBall::SerialISR(void)
{
    char c;
    
    while ( _serial.readable() )
    {
        c = _serial.getc();
        
        Process ( c );
    }
}

///////////////////////////////////////////////////////////////////////////////

void SpaceBall::Process ( char c )
{
    if ( _bSpaceOrb )
        ProcessSO ( c );
    else
        ProcessSB ( c );
}

///////////////////////////////////////////////////////////////////////////////

float SpaceBall::GetAxis ( int nAxis ) const
{
    float fValue = 0;
    
    if ( _mapping == CNC )
    {
        if      ( nAxis == TX ) fValue = _axis[0];
        else if ( nAxis == TY ) fValue = _axis[2];
        else if ( nAxis == TZ ) fValue = _axis[1];
        else if ( nAxis == RX ) fValue = -_axis[0];
        else if ( nAxis == RY ) fValue = -_axis[2];
        else if ( nAxis == RZ ) fValue = -_axis[1];
    }
    else if ( _mapping == CNCvert )
    {
        if      ( nAxis == TX ) fValue = _axis[0];
        else if ( nAxis == TY ) fValue = _axis[1];
        else if ( nAxis == TZ ) fValue = -_axis[2];
        else if ( nAxis == RX ) fValue = -_axis[0];
        else if ( nAxis == RY ) fValue = -_axis[1];
        else if ( nAxis == RZ ) fValue = -_axis[2];
    }
    else
    {
        if      ( nAxis == TX ) fValue = _axis[0];
        else if ( nAxis == TY ) fValue = _axis[1];
        else if ( nAxis == TZ ) fValue = _axis[2];
        else if ( nAxis == RX ) fValue = _axis[0];
        else if ( nAxis == RY ) fValue = _axis[1];
        else if ( nAxis == RZ ) fValue = _axis[2];
    }
    
    if ( nAxis <= TZ )
        fValue *= _fScaleT * _fScale;
    else
        fValue *= _fScaleR * _fScale;
        
    return fValue;
}

///////////////////////////////////////////////////////////////////////////////

int SpaceBall::GetAxisRaw ( int nAxis ) const
    {
        if ( nAxis<0 || nAxis>5 )
            return 0;
        
        return _axis[nAxis];
    }
    
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
