#include "SpaceBall.h"

//extern Serial pc;

///////////////////////////////////////////////////////////////////////////////

static unsigned char spaceorb_xor[] = "SpaceWare";
/*
static unsigned char spaceorb_errors[][32] = { 
    "EEPROM storing 0 failed", "Receive queue overflow", "Transmit queue timeout",
    "Bad packet", "Power brown-out", "EEPROM checksum error", "Hardware fault" };
*/

void SpaceBall::InitSO()
{
    _fScaleT = 1.0 / 512.0;
    _fScaleR = 1.0 / 512.0;
}

///////////////////////////////////////////////////////////////////////////////

void SpaceBall::ProcessSO ( char data )
{
    if (~data & 0x80) {
        _data[_idx] = 0;
        if (_idx)
            ProcessPacketSO();
        _idx = 0;
    }
    if (_idx < SPACEBALL_MAX_LENGTH)
        _data[_idx++] = data & 0x7f;
}

///////////////////////////////////////////////////////////////////////////////

void SpaceBall::ProcessPacketSO ( void )
{
    int i;
    char c = 0;

    if (_idx < 2) return;
    for (i = 0; i < _idx; i++) c ^= _data[i];
    if (c) return;

    switch (_data[0]) {

        case 'R':               /* Reset packet */
            break;

        case 'D':               /* Ball + button data */
        {
            short axes[6];
            
            if (_idx != 12) return;
            for (i = 0; i < 9; i++) _data[i+2] ^= spaceorb_xor[i];
            axes[0] = ( _data[2]  << 3) | (_data[ 3] >> 4);
            axes[1] = ((_data[3] & 0x0f) << 6) | (_data[ 4] >> 1);
            axes[2] = ((_data[4] & 0x01) << 9) | (_data[ 5] << 2) | (_data[4] >> 5);
            axes[3] = ((_data[6] & 0x1f) << 5) | (_data[ 7] >> 2);
            axes[4] = ((_data[7] & 0x03) << 8) | (_data[ 8] << 1) | (_data[7] >> 6);
            axes[5] = ((_data[9] & 0x3f) << 4) | (_data[10] >> 3);
            for (i = 0; i < 6; i++)
                _axis[i] = axes[i] - ((axes[i] & 0x200) ? 1024 : 0);
            _buttons = _data[1];
            DoChangedAxis();
            DoChangedButtons();
            }
            break;

        case 'K':               /* Button data */
            if (_idx != 5) return;
            _buttons = _data[2];
            DoChangedButtons();
            break;

        case 'E':               /* Error packet */
            if (_idx != 4) return;
            //printf(KERN_ERR "joy-spaceorb: Device error. [ ");
            //for (i = 0; i < 7; i++) if (_data[1] & (1 << i)) printf("%s ", spaceorb_errors[i]);
            //printf("]\n");
            break;

        default:
            /* eat and ignore these packets */
            //pc.printf("<%s>\r\n",_data);
            break;
    }
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
