#define MQTTSNCLIENT_QOS2 1

#include "mbed.h"
#include "stdio.h"
#include "MQTT_server_setting.h"
#include "MQTTSNUDP.h"
#include "MQTTSNClient.h"
#include "sensor.h"
#include "Enumeration.h"
#include "easy-connect.h"
#include "MQTTSN_func.h"
#include "registration.h"
#include "container.h"
#include "contentInstance.h"
#include "Subscription.h"

NetworkInterface* network = NULL;

int main() {
       
    float version = 1.0;
    MQTTSNUDP* ipstack = NULL;
    MQTTSN::Client<MQTTSNUDP, Countdown> *client = NULL;
    
    /////////////////////////////////////////////////////////////////////////////////////////
    printf("Opening network interface...\r\n");
    {
        network = easy_connect(true);    // If true, prints out connection details.
        if (!network) {
            printf("Unable to open network interface.\r\n");
            return -1;
        }
    }
    printf("Network interface opened successfully.\r\n");
    printf("\r\n");

    const char* Local_IP = network->get_ip_address();
    printf("IP Address of Device is: %s\n", Local_IP);
    
    const char* Local_MAC = network->get_mac_address();
    printf("MAC Address of Device is: %s\n", Local_MAC);
    /////////////////////////////////////////////////////////////////////////////////////////
    ipstack = new MQTTSNUDP(network);
    client = new MQTTSN::Client<MQTTSNUDP, Countdown>(*ipstack);
    
    //////////////////////////////////UDP Connect///////////////////////////////////////////    
    printf("Connecting to %s:%d\n", MQTT_SERVER_HOST_NAME, PORT);
    rc = ipstack->connect(MQTT_SERVER_HOST_NAME, PORT);
    if (rc != 0)
        printf("rc from UDP connect is %d\n", rc);
    else
        printf("UDP connected\n"); 
       
    //////////////////////////////////MQTT Connect///////////////////////////////////////////
    attemptConnect(client, ipstack);
    
    //////////////////////////////////MQTT Subscribe//////////////////////////////////////////
    
    //Set Topic to /oneM2M/reg_resp/Sensor01/CSE_01
    create_Topic("reg_resp", MQTT_CLIENT_ID, "CSE_01");
    
    MQTTSN_topicid topicid;
    if ((rc = subscribe(client, ipstack, topicid)) != 0)
        printf("rc from MQTT subscribe is %d\n", rc);
    else
        printf("Subscribed to Topic %s\n", MQTT_TOPIC);

    //Set Topic to /oneM2M/reg_req/Sensor01/CSE_01
    create_Topic("reg_req", MQTT_CLIENT_ID, "CSE_01");
    
    MQTTSN_topicid topicid2;    
    if ((rc = subscribe(client, ipstack, topicid2)) != 0)
        printf("rc from MQTT subscribe is %d\n", rc);
    else
        printf("Subscribed to Topic %s\n", MQTT_TOPIC);
    
    //////////////////////////////////Registration///////////////////////////////////////////
    if(Registration(client, ipstack, topicid2) != 0 )
        printf("Registration failed with response: %s\n", response.c_str());
    else printf("Registration Done wth response: %s\n", response.c_str());
  
    ////////////////////////////////Req-Resp Topics//////////////////////////////////////////
    c_aei =  new char [aei.length()+1];;
    printf("\nAEI in main: %s\r\n\n\n", aei.c_str());
    strcpy(c_aei, aei.c_str());
    printf("C_AEI: %s\r\n", c_aei);
    
    //Set Topic to /oneM2M/resp/SAE01/CSE_01
    create_Topic("resp", c_aei, "CSE_01");
    
    MQTTSN_topicid topicid3;
    if ((rc = subscribe(client, ipstack, topicid3)) != 0)
         printf("rc from MQTT subscribe is %d\n", rc);
    else
         printf("Subscribed to Topic %s\n", MQTT_TOPIC);
        
    //Set Topic to /oneM2M/req/SAE01/CSE_01
    create_Topic("req", c_aei, "CSE_01");
    
    MQTTSN_topicid topicid4;
    if ((rc = subscribe(client, ipstack, topicid4)) != 0)
         printf("rc from MQTT subscribe is %d\n", rc);
    else
         printf("Subscribed to Topic %s\n", MQTT_TOPIC);
    wait(3);    
    
    ////////////////////////////////// Container ////////////////////////////////////////////
    if(Container(client, ipstack, topicid4) != 0 )
        printf("Container Creation failed with response: %s\n", response.c_str());
    else printf("Container Created wth response: %s\n", response.c_str());
    wait(3);
    ////////////////////////////////// Subscription ////////////////////////////////////////////
    if(Subscription(client, ipstack, topicid4) != 0 )
        printf("Subscription Creation failed with response: %s\n", response.c_str());
    else printf("Subscription Created wth response: %s\n", response.c_str());
    wait(3);
    ////////////////////////////////// ContentInstance //////////////////////////////////////
    if(contentInstance(client, ipstack, topicid4) != 0 )
        printf("ContentInstance Creation failed with response: %s\n", response.c_str());
    else printf("ContentInstance Created wth response: %s\n", response.c_str());
    
    rc = delete_cnt(client, ipstack, topicid4);
    rc = delete_sub(client, ipstack, topicid4);
    
 
    while(1) 
    {
        // Check connection //
        if(!client->isConnected()){
            break;
        }
        // Received a control message. //
        if(isMessageArrived) {
            isMessageArrived = false;
            // Just print it out here.
            printf("\r\nMessage arrived:\r\n%s\r\n", messageBuffer);
            
            //generate notification response
            if(op == 5)
            {
                Response Resp;
                RES.resourceName = rn;
                Resp.Request_Identifier = rqi;
                Resp.To = From;
                lcl = false;
                Resp.From = CSE_ID;
                buf = Notify_Resp(Resp);
                if ((rc = publish(client, ipstack, topicid3)) != 0)
                    printf("rc from MQTT Publish is %d\n", rc);
                else
                    printf("Published Buffer: %s to Topic %s\n",buf, MQTT_TOPIC);
            }
            
        }          
            client->yield(4000);
            //wait(4);
    } 
    
    //if ((rc = client->unsubscribe(topicid2)) != 0)
    //    printf("rc from unsubscribe was %d\n", rc);
    
    if ((rc = client->disconnect()) != 0)
        printf("rc from disconnect was %d\n", rc);
 
    ipstack->disconnect();
    
    delete ipstack;
    delete client;
    
    printf("Version %.2f: finish %d msgs\n", version, arrivedcount);
    printf("Finishing with %d messages received\n", arrivedcount);
    
    return 0;

}
