#include "mbed.h"
#include "m3pi.h"
//#include "MSCFileSystem.h"

m3pi pololu;

Serial usb(p28,p27);

DigitalOut l1(LED1);
DigitalOut l2(LED2);
DigitalOut l3(LED3);
DigitalOut l4(LED4);

float speed = 0.5;
int seuil = 500;


int main()
{

    int capteurs[5]= {1,1,1,1,1};
    int cap_seuil[5]= {0,0,0,0,0};
    char buff[8];
    char c;

    pololu.sensor_auto_calibrate();

    while(1) {
        //affichage valeur capteur
        //Boucle switch de reception de données via serial
        if(usb.readable()) 
        {
            c = usb.getc();
            switch(c){
            case '0':
                pololu.sensor_auto_calibrate();
                break;
            case 'z':
                pololu.forward(speed);
                l1 = 1;
                l2 = 0;
                l3 = 0;
                l4 = 0;
                break;
            case 's':
                pololu.backward(speed);
                l1 = 0;
                l2 = 1;
                l3 = 0;
                l4 = 0;
                break;
            case 'q':
                pololu.left(0.3);
                l1 = 1;
                l2 = 0;
                l3 = 0;
                l4 = 0;
                break;
            case 'd':
                pololu.right(0.3);
                l1 = 1;
                l2 = 0;
                l3 = 0;
                l4 = 0;
                break;
            case 'a':
                speed += 0.1;
                if(speed > 1) speed = 1;
                pololu.cls();
                pololu.locate(0,0);
                sprintf(buff, "Spd:%3.f",speed );
                pololu.print(buff,8);

                break;
            case 'e':
                speed -= 0.1;
                if(speed < 0) speed = 0;
                pololu.cls();
                pololu.locate(0,0);
                sprintf(buff, "Spd:%3.f",speed );
                pololu.print(buff,8);
                break;
            case ' ':
                pololu.stop();
                l1 = 1;
                l2 = 1;
                l3 = 1;
                l4 = 1;
                break;
            case 'c':
                pololu.readsensor(capteurs);
                for(int i=0; i<5; i++)
                {
                    if(capteurs[i] >= seuil)
                    {
                        cap_seuil[i] = 1;
                    }
                    else 
                    {
                        cap_seuil[i] = 0;
                    }
                }

                 if(usb.writable()) 
                 {
                        usb.printf("Valeur capteur :  \r\n");
                        usb.printf("Valeurs brutes: %d, %d, %d, %d, %d  \r\n", (int)capteurs[0],(int)capteurs[1],(int)capteurs[2],(int)capteurs[3],(int)capteurs[4]);
                        usb.printf("Valeurs seuillees: %d, %d, %d, %d, %d  \r\n \r\n ",cap_seuil[0],cap_seuil[1],cap_seuil[2],cap_seuil[3],cap_seuil[4]);
                }
                break;

            case 'b':
                sprintf(buff, "Bat:%3.f",pololu.battery());
                pololu.cls();
                pololu.locate(0,0);
                pololu.print(buff,8);
                break;
            case 'y' :
                speed = 0.3;
                pololu.forward(speed);
                wait(3);
                pololu.stop();
                wait(1);
                pololu.left(speed);
                wait(2);
                pololu.right(speed);
                wait(1);
                break;

            default : break;
            }
        }
    }
}