#include "mbed.h"
#include "nRF24L01P.h"
#include <string.h>

#define SPI2_MOSI PD_4
#define SPI2_MISO PD_3
#define SPI2_SCLK PD_1
#define CSN D9
#define CE D8
#define IRQ D1

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(SPI2_MOSI, SPI2_MISO, SPI2_SCLK, CSN, CE, IRQ);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

int main() 
{
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE 4

    char txData[TRANSFER_SIZE];
    int txDataCnt = 0;

    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf("Default setup : \r\n");
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
    pc.printf("\r\n\r\n");

    my_nrf24l01p.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY);
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_2_MBPS);
    my_nrf24l01p.setTxAddress(0xFFA);
    my_nrf24l01p.setRxAddress(0xFFE);
    
    pc.printf("Custom setup : \r\n");
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
    pc.printf("\r\n\r\n");
    

    pc.printf( "Spamming routine enabled !\r\n");

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setTransmitMode();
    my_nrf24l01p.enable();
    
    
    char* data = "Hello PC !\r\n";
    int dataSize = strlen(data) + 1;
    int i = 0;

    while (1) 
    {
        //Send "Hello PC" to the PC board

        // add datas to the transmit buffer
        txData[txDataCnt++] = data[i++];
        
        pc.printf("%d", i);
        
        if (i >= dataSize)
        {
            i = 0;

        }
        // If the transmit buffer is full
        if ( txDataCnt >= sizeof( txData ) ) {

            // Send the transmitbuffer via the nRF24L01+
            my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );

            txDataCnt = 0;
        }

        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        myled1 = !myled1;
    }
}
