#include "protocol.h"
#include "circularBuffer.h"

//------------------------------------------------Encodage/Decodage des trames------------------------------------------------//
//!!! La taille de "msg[]" doit être [msgPayloadLength + 6]
void encodeAndSendMessage(int msgFunction, int msgPayloadLength, char* msgPayload)
{
    int msgIndex = 0;
    char msg[msgPayloadLength + 6];
    msg[msgIndex++] = 0xFE;                                                                //Start of Frame
    msg[msgIndex++] = (char)(msgFunction >> 8);                                            //Message Function MSB
    msg[msgIndex++] = (char)(msgFunction);                                                 //Message Function LSB
    msg[msgIndex++] = (char)(msgPayloadLength >> 8);                                       //Message Payload Length MSB
    msg[msgIndex++] = (char)(msgPayloadLength);                                            //Message Payload Length LSB
    int j;
    for (j = 0 ; j < msgPayloadLength; j++)
        msg[msgIndex++] = msgPayload[j];                                                   //MessagePayload
    msg[msgIndex++] = calculateChecksum(msgFunction, msgPayloadLength, msgPayload);        //Checksum
    
    cbTxSendMessage(msg, msgPayloadLength + 6);
}

char calculateChecksum(int msgFunction, int msgPayloadLength, char* msgPayload)
{
    char checksum = 0xFE;
    checksum ^= (char)(msgFunction >> 8);
    checksum ^= (char)(msgFunction);
    checksum ^= (char)(msgPayloadLength >> 8);
    checksum ^= (char)(msgPayloadLength);
    int i;
    for(i = 0; i < msgPayloadLength; i++)
        checksum ^= msgPayload[i];
    
    return checksum;
}

unsigned char rcvState = WAITING;
int decodedMsgFunction;
int decodedPayloadLength;
char decodedPayload[BUFFER_SIZE];
int decodedPayloadIndex = 0;

void decodeMessage(char receivedByte)
{
    switch(rcvState)
    {
        case WAITING:
            if (receivedByte == 0xFE)
                rcvState = FUNCTION_MSB;
            break;
            
        case FUNCTION_MSB:
            decodedMsgFunction = receivedByte << 8;
            rcvState = FUNCTION_LSB;
            break;
            
        case FUNCTION_LSB:
            decodedMsgFunction += receivedByte;
            rcvState = LENGTH_MSB;
            break;
            
        case LENGTH_MSB:
            decodedPayloadLength = receivedByte << 8;
            rcvState = LENGTH_LSB;
            break;
            
        case LENGTH_LSB:
            decodedPayloadLength += receivedByte;
            rcvState = PAYLOAD;
            break;
            
        case PAYLOAD:
            if(decodedPayloadLength >= BUFFER_SIZE)
            {
                rcvState = WAITING;
                decodedPayloadLength = 0;
                decodedMsgFunction = 0;
            }
            else if (decodedPayloadLength > 0)
            {
                decodedPayload[decodedPayloadIndex++] = receivedByte;
                if (decodedPayloadIndex >= decodedPayloadLength)
                {
                    rcvState = CHECKSUM;
                    decodedPayloadIndex = 0;
                }
            }
            else
            {
                rcvState = CHECKSUM;
            }
            break;
            
        case CHECKSUM:
        {    
            char calculatedChecksum = calculateChecksum(decodedMsgFunction, decodedPayloadLength, decodedPayload);
            if (calculatedChecksum == receivedByte)
            {
                //Victoire, la trame recu correspond à la trame envoyé
                //TODO: Faire une fonction qui traite la charge utile apres décodage.
            }
            
            rcvState = WAITING;
            break;
        }
    }
}