#include "circularBuffer.h"

//-----------------------------TX-----------------------------//
int cbTxHead;
int cbTxTail;
char cbTxBuffer[BUFFER_SIZE];

void cbTxSendMessage(char* message, int length)
{
    int i;
    if (cbTxRemainingSize() > length)
        for (i = 0; i < length; i++)
            cbTxAddOne(message[i]);
}

void cbTxAddOne(char value)
{
    if (cbTxRemainingSize() > 0)
    {
        cbTxBuffer[cbTxHead++] = value;
        if (cbTxHead >= BUFFER_SIZE)
            cbTxHead = 0;
    }
}

char cbTxGetOne()
{
    char value = cbTxBuffer[cbTxTail++];
    if (cbTxTail >= BUFFER_SIZE)
        cbTxTail = 0;
    return value;
}

int cbTxRemainingSize()
{
    int size;
    if (cbTxTail > cbTxHead)
        size = cbTxTail - cbTxHead;
    else
        size = BUFFER_SIZE - (cbTxHead - cbTxTail);
    return size;
}

int cbTxGetDataSize()
{
    return BUFFER_SIZE - cbTxRemainingSize();
}


//-----------------------------RX-----------------------------//
int cbRxHead;
int cbRxTail;
char cbRxBuffer[BUFFER_SIZE];

void cbRxAddOne(char value)
{
    if (cbRxRemainingSize() > 0)
    {
        cbRxBuffer[cbRxHead++] = value;
        if (cbRxHead >= BUFFER_SIZE)
            cbRxHead = 0;
    }
}

char cbRxGetOne()
{
    char value = cbRxBuffer[cbRxTail++];
    if (cbRxTail >= BUFFER_SIZE)
        cbRxTail = 0;
    return value;    
}

unsigned char cbRxIsDataAvailable()
{
    if (cbRxTail != cbRxHead)
        return 1;
    else
        return 0;
}

int cbRxRemainingSize()
{
    int size;
    if (cbRxTail > cbRxHead)
        size = cbRxTail - cbRxHead;
    else
        size = BUFFER_SIZE - (cbRxHead - cbRxTail);
    return size;
}

int cbRxGetDataSize()
{
    return BUFFER_SIZE - cbRxRemainingSize();
}