#include "main.h"
#include "mbed.h"
#include "nRF24L01P.h"
#include "circularBuffer.h"

UnbufferedSerial pc(USBTX, USBRX, 115200); // tx, rx, baudrate

nRF24L01P my_nrf24l01p(SPI3_MOSI, SPI3_MISO, SPI3_SCLK, CSN, CE, IRQ);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(D4);
DigitalOut myled2(D5);

char sendFlag = 0;

int main() 
{
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
    char txData[TRANSFERT_SIZE];
    
    //Interruption sur réception Port Série
    pc.attach(&usbRxInterrupt, SerialBase::RxIrq);
    
        
    my_nrf24l01p.powerUp();
    
    //Configuration nRF24101P
    my_nrf24l01p.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY);
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_2_MBPS);
    my_nrf24l01p.setRfOutputPower(-6);
    my_nrf24l01p.setTxAddress(0xFFA);
    my_nrf24l01p.setRxAddress(0xFFE);
    my_nrf24l01p.setTransferSize(TRANSFERT_SIZE);
    my_nrf24l01p.setTransmitMode();
    
    my_nrf24l01p.enable();
    
    
    //Infinite Loop
    while (1) 
    {
        // Si une trame est prête (4 octets)
        if (sendFlag) 
        {
            sendFlag = 0;
            int i;
            
            //On récupère la trame du buffer
            for (i = 0; i < TRANSFERT_SIZE; i++)
                txData[i] = cbTxGetOne();

            // Send the transmitbuffer via the nRF24L01+
            my_nrf24l01p.write(NRF24L01P_PIPE_P0, txData, TRANSFERT_SIZE);

            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
            myled1 = !myled1;
        }
    }
}

void usbRxInterrupt()
{
    //On a reçu un octet, on le récupère et on le met dans le buffer
    char c;
    if(pc.read(&c, 1)) 
    {
        cbTxAddOne(c);
        //S'il y a 4 octets dans le buffer, on peut les envoyer (passage du flag à 1)
        if (cbTxGetDataSize() >= 4)
            sendFlag = 1;
    }
}