/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500


int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led1(D4);
    DigitalOut led2(D5);
    
    led2 = 1;
    
    while (true) {
        led1 = !led1;
        led2 = !led2;
        
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
