#include "mbed.h"
#include "fm.h"


I2C i2c(p9,p10);    // SDA,SCI

DigitalOut f_led1(LED1);

void fmSetup(unsigned int _f)
{
    char freqH = 0, freqL = 0;//, c, i;
    unsigned int freq, freqB;
    const int addr = 0x11;     //slave address
    const int i2c_write = (addr << 1) | I2C_WRITE;
    const int i2c_read = (addr << 1) | I2C_READ;
        
    freq = _f;         //freq/10.MHz   760~910
    
    freq = _f;                            // 89.2 MHz
    if(freq > 870){
         freqB = freq - 870;
         freqH = freqB>>2;
         freqL = (freqB&3)<<6;                  // Shift channel selection for matching register 0x03
    }else{
        freqB = freq-760;
        freqH = freqB>>2;
        freqL = (freqB&3)<<6;
    }
       
    i2c.start();
    i2c.write(i2c_write);
    i2c.write(0x02);
    i2c.write(
        1*I2C_NORMAL_OUTPUT_Z |
        1*I2C_NO_MUTE |
        1*I2C_MONORAL |
        0*I2C_BASS_BOOST 
    );
    i2c.write(//0x0D
        
        I2C_CLK_32k |
        1*I2C_ANTENNA_INNER |
        0*I2C_SOFT_RESET |
        1*I2C_POWER_UP
        
    );
    i2c.stop();
    wait(0.5);   
   
    if(freq > 870){
        freqL=freqL | 0x10;
    }else{ 
        freqL=freqL | 0x14;
    }
    i2c.start();
    i2c.write(i2c_write);
    i2c.write(0x03);
    i2c.write(freqH);
    i2c.write(freqL);
    i2c.stop();
    wait(0.5);
   
    //Transmitter mode
    i2c.start();
    i2c.write(i2c_write);
    i2c.write(0x40);
    i2c.write(0x00);
    i2c.write(0x01);
    i2c.stop();
    wait(0.5);

    //configure each gain
    i2c.start();
    i2c.write(i2c_write);
    i2c.write(0x42);
    i2c.write(0x02);        //audio gain
    i2c.write(0x0F);        //antenna gain
    i2c.stop();
   
    wait(0.5);
    
    f_led1 = 1;
}

void fmStop(){
    const int addr = 0x11;     //slave address
    const int i2c_write = (addr << 1) | I2C_WRITE;
    
    i2c.start();
    i2c.write(i2c_write);
    i2c.write(0x02);
    i2c.write(
        1*I2C_NORMAL_OUTPUT_Z |
        0*I2C_NO_MUTE |
        1*I2C_MONORAL |
        0*I2C_BASS_BOOST 
    );
    i2c.write(//0x0D
        
        I2C_CLK_32k |
        1*I2C_ANTENNA_INNER |
        0*I2C_SOFT_RESET |
        1*I2C_POWER_UP
        
    );
    i2c.stop();
}

void fmRestart(){
    const int addr = 0x11;     //slave address
    const int i2c_write = (addr << 1) | I2C_WRITE;
    
    i2c.start();
    i2c.write(i2c_write);
    i2c.write(0x02);
    i2c.write(
        1*I2C_NORMAL_OUTPUT_Z |
        1*I2C_NO_MUTE |
        1*I2C_MONORAL |
        0*I2C_BASS_BOOST 
    );
    i2c.write(//0x0D
        
        I2C_CLK_32k |
        1*I2C_ANTENNA_INNER |
        0*I2C_SOFT_RESET |
        1*I2C_POWER_UP
        
    );
    i2c.stop();
}