#ifndef _INC_MY_BLUETOOTH
#define _INC_MY_BLUETOOTH

#include "mbed.h"

#define BT_MASTER 0
#define BT_SLAVE -1

#define SYNC_SENSOR 0x10
#define SYNC_MIC 0x11
#define SYNC_MOTOR 0x20
#define SYNC_FM 0x21

#define PACK_SIZE 15

typedef union _cvt{
    char byte[4];
    int in;
    float fl;
} Cvt;

void btSetup(int);          //setup(role) role:BT_MASTER or BT_SLAVE

int readPack( char* );

void sync(char, char*, float*);     //SYN(option,char_data,float_data); only for MASTER

void slaveRecieve( void );
void recieveSensor(float*, float*);
void sendMotor( char function, float power );

//void btLoop(int);       //btLoop(role)  role:BT_MASTER or BT_SLAVE

#endif