#include "mbed.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>

PwmOut pwmA(PB_3); //D3
PwmOut pwmB(PB_4); //D5


int main() {
    
    char str[50];
    
    while(1) 
    { 
        printf("Enter a Voltage (-3.3 to 3.3 V) : \n");
        gets(str); //get string from terminal
        
        float voltage = atof(str); //convert str to float
        
        printf("You entered: %s\n Output Voltage = %f \n", str, voltage);
        
        if (voltage > 0.0){
            pwmB.write(0);
            float duty = voltage/3.3;
            printf("Duty Cycle: %f \n", duty);
            pwmA.period(0.0001);
            pwmA.write(duty);
        }
        else if (voltage < 0.0){
            pwmA.write(0);
            float duty = -(voltage)/3.3;
            printf("Duty Cycle: %f \n", duty);
            pwmB.period(0.0001);
            pwmB.write(duty);
        }
        else if (voltage == 0.0){
            pwmA.write(0);
            pwmB.write(0);
            pwmA.period(0.0001);
            pwmB.period(0.0001);
            float duty = 0;
            printf("Duty Cycle: %f \n", duty);
        }
        else if (voltage > 3.3 | voltage < -3.3){
            printf("Invalid Voltage input \n");
        }
    }
}
