#include "mbed.h"
#include "MPU9250.h" 
#include "math.h" 
#include "kalman.h"

Serial aa(USBTX,USBRX);


class ZMU9250
{
    public:
        ZMU9250()
        {
              
              //Set up I2C
              i2c.frequency(400000);  // use fast (400 kHz) I2C  
              this->t.start();        
              
              // Read the WHO_AM_I register, this is a good test of communication
              uint8_t whoami = this->mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);  // Read WHO_AM_I register for MPU-9250
              if ((whoami == 0x73)||(whoami == 0x71)) // WHO_AM_I should always be 0x68
              {  
                wait(1);
                this->mpu9250.resetMPU9250(); // Reset registers to default in preparation for device calibration
                this->mpu9250.MPU9250SelfTest(SelfTest); // Start by performing self test and reporting values
                this->mpu9250.calibrateMPU9250(gyroBias, accelBias); // Calibrate gyro and accelerometers, load biases in bias registers  
                wait(2);
                this->mpu9250.initMPU9250(); 
                this->mpu9250.initAK8963(magCalibration);
                wait(1);
               }
               else
               {
                while(1) ; // Loop forever if communication doesn't happen
                }
                this->mpu9250.getAres(); // Get accelerometer sensitivity
                this->mpu9250.getGres(); // Get gyro sensitivity
                this->mpu9250.getMres(); // Get magnetometer sensitivity
                //magbias[0] = +470.;  // User environmental x-axis correction in milliGauss, should be automatically calculated
                //magbias[1] = +120.;  // User environmental x-axis correction in milliGauss
                //magbias[2] = +125.;  // User environmental x-axis correction in milliGauss
                magbias[0] = +470;  // User environmental x-axis correction in milliGauss, should be automatically calculated
                magbias[1] = +120;  // User environmental x-axis correction in milliGauss
                magbias[2] = +125;  // User environmental x-axis correction in milliGauss
        }
        
        void Update()
        {
            if(this->mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01) {  // On interrupt, check if data ready interrupt
                this->mpu9250.readAccelData(accelCount);  // Read the x/y/z adc values   
                // Now we'll calculate the accleration value into actual g's
                ax = (float)accelCount[0]*aRes - accelBias[0];  // get actual g value, this depends on scale being set
                ay = (float)accelCount[1]*aRes - accelBias[1];   
                az = (float)accelCount[2]*aRes - accelBias[2];  
                this->mpu9250.readGyroData(gyroCount);  // Read the x/y/z adc values
                // Calculate the gyro value into actual degrees per second
                gx = (float)gyroCount[0]*gRes - gyroBias[0];  // get actual gyro value, this depends on scale being set
                gy = (float)gyroCount[1]*gRes - gyroBias[1];  
                gz = (float)gyroCount[2]*gRes - gyroBias[2];   
                this->mpu9250.readMagData(magCount);  // Read the x/y/z adc values   
                // Calculate the magnetometer values in milliGauss
                // Include factory calibration per data sheet and user environmental corrections
                mx = (float)magCount[0]*mRes*magCalibration[0] - magbias[0]+360.0f;  // get actual magnetometer value, this depends on scale being set
                my = (float)magCount[1]*mRes*magCalibration[1] - magbias[1]-210.0f;  
                mz = (float)magCount[2]*mRes*magCalibration[2] - magbias[2];
                //aa.printf("x %f\ty %f\tz %f\n",mx,my,mz);
                
                
            } // end if one
            Now = this->t.read_us();
            deltat = (float)((Now - lastUpdate)/1000000.0f) ; // set integration time by time elapsed since last filter update
            lastUpdate = Now;
            this->sum += deltat;
            sumCount++;
            this->mpu9250.MadgwickQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f,  my,  mx, mz);
            
            // Pass gyro rate as rad/s
            /*if((rand()%20)>=0)
            {
            this->mpu9250.MadgwickQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f,  my,  mx, mz);
            }else
            {
            //this->mpu9250.MahonyQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f, my, mx, mz);
            this->mpu9250.Mad_Update(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f);
            }*/
            
            
            // Serial print and/or display at 0.5 s rate independent of data rates
            delt_t = this->t.read_ms() - count;
            if (delt_t > 10) { // update LCD once per half-second independent of read rate
                tempCount = this->mpu9250.readTempData();  // Read the adc values
                temperature = ((float) tempCount) / 333.87f + 21.0f; // Temperature in degrees Centigrade
              // Define output variables from updated quaternion---these are Tait-Bryan angles, commonly used in aircraft orientation.
              // In this coordinate system, the positive z-axis is down toward Earth. 
              // Yaw is the angle between Sensor x-axis and Earth magnetic North (or true North if corrected for local declination, looking down on the sensor positive yaw is counterclockwise.
              // Pitch is angle between sensor x-axis and Earth ground plane, toward the Earth is positive, up toward the sky is negative.
              // Roll is angle between sensor y-axis and Earth ground plane, y-axis up is positive roll.
              // These arise from the definition of the homogeneous rotation matrix constructed from quaternions.
              // Tait-Bryan angles as well as Euler angles are non-commutative; that is, the get the correct orientation the rotations must be
              // applied in the correct order which for this configuration is yaw, pitch, and then roll.
              // For more see http://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles which has additional links.
                yaw   = atan2(2.0f * (q[1] * q[2] + q[0] * q[3]), q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3]);   
                //yaw   = atan2(2.0f * (q[0] * q[2] + q[0] * q[3]), 1 - 2 * (  q[2] * q[2] + q[3] * q[3]));   
                pitch = -asin(2.0f * (q[1] * q[3] - q[0] * q[2]));
                
                //pitch = atan2(2.0f * (q[1] * q[3] - q[0] * q[2]),q[0]*q[0]-q[1]*q[1]+q[2]*q[2]-q[3]*q[3]);
                roll  = atan2(2.0f * (q[0] * q[1] + q[2] * q[3]), q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3]);
                //pitch = atan2(sin(roll)*(q[1]*q[3]-q[0]*q[2]),q[1]*q[2]+q[0]*q[3]);
                pitch *= 180.0f / PI;
                yaw   *= 180.0f / PI; 
                //yaw   -= 13.8f; // Declination at Danville, California is 13 degrees 48 minutes and 47 seconds on 2014-04-04
                yaw -= 0.35f;
                roll  *= 180.0f / PI;
                this->roll_x = roll;
                this->pitch_y = pitch;
                this->yaw_z = yaw;//(this->kal.getAngle(yaw*PI/180.0f,0.00,delt_t));
                count = this->t.read_ms(); 
                if(count > 1<<21) {
                    this->t.start(); // start the timer over again if ~30 minutes has passed
                    count = 0;
                    deltat= 0;
                    lastUpdate = this->t.read_us();
                } // end if three.
                this->sum = 0;
                sumCount = 0; 
            } // end if two.
        }
        
        
        float Roll()
        {
          return roll_x;   
        }
        
        float Pitch()
        {
          return pitch_y;   
        }
        
        float Yaw()
        {
          return yaw_z;   
        }
        
        
    private:
        float sum;
        uint32_t sumCount;
        char buffer[14];
        int roll_x;
        kalman kal();
        int pitch_y;
        int yaw_z;
        MPU9250 mpu9250;
        Timer t;
        
           
};


