#include "mbed.h"
#include "Moop.h"
#include "bmu.h"
#include "Latrix.h"
#include "zmu9250.h"
#include "MPU9250.h"
#include "time.h"

InterruptIn lim(PinName D3);
InterruptIn rotate(PinName  D4);
InterruptIn choose(PinName  D5);
Ticker flipper;
Ticker Update;

Moop map;

Serial pc(PinName  USBTX,PinName  USBRX);
Serial mas(PinName D8,PinName D2);

bmuimu imu;
Latrix ledMatrix;

Timer t;

bool anach ;
bool buttonState ; // button limit switchm rotate and choose state respectively.
unsigned int count; // count down.
char data[50];
char elem;
bool error ; // store error in ambigous imu data. 
int helperRoll , helperPitch,helperYaw;
unsigned int indx ;
unsigned int state ;

// state    0 = initial / start.
//          1 = waiting for limit switch.

unsigned int turn ; // turn.

unsigned int x , y , z ,lx,ly,lz;
int winStatus ;

void Rise(int but)
{
    buttonState[but-3] = 1;
}

void Fall(int but)
{
    buttonState[but-3] = 0;   
}

void Update()
{
    imu.Update();   
}

void Sent(char arrayi[],float it,int siz)
{
    for (int i = 0;i<siz;i++)
        {
            mas.putc(arrayi[i]);
            wait(it);
        }   
}

void getStr()
{
    while (mas.readable())
    {
        
        elem = mas.getc();
        pc.printf("char is %d\n\r",elem);
        if ((elem == '\n'))
        {
            pc.printf("string is %s\n\r",data);   
            for(int i=0;i<indx;i++)
            {
                if (indx > 2)
                {
                    dete[i] = data[i];      
                }
            }
            for(int i=0;i<30;i++)
            {
                data[i] = '\0';
            }
            indx = 0;
            break;
        }else
        {
            data[indx] = elem;
            indx += 1;
        }
            
    }  
}

void ShowMap()
{
    int mmapx[5][5][5] = {0};
    int mmapy[5][5][5] = {0};
    for(int i=0;i<5;i++)
    {
        for(int j = 0;j<5;j++)
        {
            for (int k =0;k<5;k++)
            {
                mmapx[i][j] = map.check1[i][j][k]*pow(2,k);
                Sent(char(mmapx[i]+64)[j],0.1,1);
                Sent("\n",0.1,1);
                mmapy[i][j] = map.check2[i][j][k]*pow(2,k);
                Sent(char(mmapy[i]+64)[j],0.1,1);
                Sent("\n",0.1,1);
            }   
        }   
    }
    int page = 0;
    while(1)
    {
        if (page == 5)
        {
            page = 4;   
        }else if(page == -1)
        {
            page = 0;   
        }
        ledMatrix.Show(mmapx[page],mmapy[page]);
        if(buttonState[2]==1)
        {
            while(buttonState[2]==1)
            {
                
            }
            page += 1;   
        }
        else if(buttonState[1]==1)
        {
            while(buttonState[1]==1)
            {
                
            }
            page -= 1;   
        }   
    }
}

void Loose()
{
    ledMatrix.Loose();
    Sent("los\n",0.1,4);
    ShowMap();
}

void Wiin()
{
    ledMatrix.Wiin();
    Sent("lwin\n",0.1,4);
    ShowMap();
}



bool chooseAnother()
{
    Sent('cho\n',0.1,4);
    while(1)
    {
        if ((dete[0]='c')&&(dete[1]='h')&&(dete[2]='0'))   
        {
            return true;
        }else if ((dete[0]='c')&&(dete[1]='h')&&(dete[2]='x')) 
        {
            return false;
        }
    }
}

bool anotherRotate()
{
    Sent('rot\n',0.1,4);
    while(1)
    {
        if ((dete[0]='r')&&(dete[1]='o')&&(dete[2]='t'))   
        {
            return true;
        }else if ((dete[0]='r')&&(dete[1]='o')&&(dete[2]='x')) 
        {
            return false;
        }
    }
}

int main()// main program of 
{   
    anach = false;
    buttonState = {0,0,0};
    count = 10;
    error = false;
    indx = 0
    helperRoll = 0
    state = 0;
    winStatus = 0;
    turn = 0;
    helperPitch=0,helperYaw=0;
     
    lim.rise(&Rise(3));
    lim.fall(&Fall(3));
    rotate.rise(&Rise(4));
    rotate.fall(&Fall(4));
    choose.rise(&Rise(5));
    choose.fall(&Fall(5));
    x = 0, y = 0, z = 0,lx=0,ly=0,lz=0;
    
    ledMatrix.Initial(); // set initial pattern in led matrix.
    wait(5); // wait 5 second for putting the box down to set initial position of imu.
    //imu.Initial(); // set initial for imu.
    Update.attach(&Update,1.0); //timer interrupt for recieving bluetooth. 
    while((dete[0]!='i')||(dete[1]!='n')||(dete[2]!='i')||(dete[3]!='t'))
    {
    }
    ledMatrix.Wbox(); // set led to tell the player that the game is ready and this is the woman-box.
    t.start();
    while (1) // void loop.
    {
        state = 1;
        
        if (buttonState[0] == 1) // if the boxes are connected.
        {
            x = map.GetCoordinateX();
            y = map.GetCoordinateY(); 
            z = map.GetCoordinateZ(); // get the position of main box which linking with map or the box not be choosen.
            /*Sent("helr\n",0.1,5); // tell the other box, that we want helper roll.
            while((dete[0]!='h')||(dete[1]!='e')||(dete[2]!='l')||(dete[3]!='r'))
            {
                pc.printf("srt %s\n\r",dete);     
            }
            helperRoll = int(  ((int(dete[4+ii])-48)*100)+((int(dete[5+ii])-48)*10)+(int(dete[6+ii])-48)  ); //get roll from another box.
            Sent("help\n",0.1,5); // tell the other box, that we want helper roll.
            while((dete[0]!='h')||(dete[1]!='e')||(dete[2]!='l')||(dete[3]!='p'))
            {
                pc.printf("srt %s\n\r",dete);     
            }
            helperPitch = int(  ((int(dete[4+ii])-48)*100)+((int(dete[5+ii])-48)*10)+(int(dete[6+ii])-48)  ); //get roll from another box.
            Sent("hely\n",0.1,5); // tell the other box, that we want helper roll.
            while((dete[0]!='h')||(dete[1]!='e')||(dete[2]!='l')||(dete[3]!='y'))
            {
                pc.printf("srt %s\n\r",dete);     
            }
            helperYaw = int(  ((int(dete[4+ii])-48)*100)+((int(dete[5+ii])-48)*10)+(int(dete[6+ii])-48)  ); //get roll from another box.*/
            //Sent("ok\n",0.1,3); //free the otherbox.
            
            error = imu.getposition(x,y,z)//,helperRoll,helperPitch,helperYaw); // calculate position from imu.
            if (error)
            {
                ledMatrix.Error()
                while(buttonState[0] == 1)
                {
                       
                }
            }else
            {
                lx = x;
                ly = y;
                lz = z;
                x = imu.getX();
                y = imu.getY();
                z = imu.getZ(); // get new possition.
                
                winStatus = map.Update(x,y,z)//,helperRoll); //update new position in map.
                
                map.ChangeOX([x,y,z,lx,ly,lz])
                if (winStatus == 1)  
                {
                    Wiin(); // win 3 in a row.
                }else if (winStatus == -1)
                {
                    Loose();// lose out of map or un valid position.
                }else 
                {
                    Sent("mapc\n",0.1,4); //map complete.
                    ledMatrix.MapComplete(); // show that this position is ok.
                    while(1)
                    {
                        anach = chooseAnother() // wheather thr others box is choosen. 
                        if ((buttonState[2]==1) && (!anach)) 
                        {
                            Sent("ch1\n",0.1,4);
                            
                            map.Choose(1); // choose main box.
                        }else if((buttonState[2]==0) && (anach))
                        {
                            map.Choose(0); // choose another box.
                            
                        }else if(buttonState[2]==0) 
                        {
                            if((buttonState[1]==0)||(anotherRotate())) // click buutton some rotate box.
                            {
                                state = 3;
                                while((buttonState[1]==0)&&(anotherRotate()))
                                {
                                    
                                }
                                
                                int yyaaww = imu.Rotate(); // check wheater rotating is error. 
                                if (false)
                                {
                                    ledMatrix.Error();
                                       
                                }else
                                {
                                    map.Rotate(0,0,yyaaww)//imu.Rotate_Yaw); // private variable/arttribute in imu class.
                                    ledMatrix.RotateComplete();   
                                }
                            }  
                        } //close choose or rotate.
                     } //close while true.
                     turn += 1; 
                     Sent("T++\n",0.1,4);
                     t.start();
                     state = 2;
                     ledMatrix.ChooseComplete();
                } // close winState.
            } // close not error.
            
        }else // if the boxes aren't connect.
        {
            if (count == 0) // time out.
            {
                t.stop();
                Loose(); // lose state
            }else if(turn != 0)
            {
                t.stop();
                if (t.read() > 1.0);
                {
                    t.start();
                    count -= 1; // time decreasing.
                }
            } // close check time
            ledMatrix.CountDown(count);.
            Sent("Tur\n",0.1,4)
        } // close boxes aren't connect.
        
    } // close loop.
    
    
    
} // close main.*/