#include "mbed.h"
#define p_scl PA_9
#define p_sda PA_10
#include "TSL2561.h"
#include "ssd1306.h"
#include "standard_font.h"
#include "bold_font.h"
#include "DHT22.h"
#include "OneWire.h"
#include "OneWireDevice.h"
#include "OneWireDeviceFactory.h"
#include "OneWireDeviceTemperature.h"
 
DigitalOut myled(LED1);
SSD1306 oled(D3 /* cs */, A0 /* reset */, A7 /* dc */,
             A1 /* clock */, A6 /* data */);
Serial serial(USBTX, USBRX);
TSL2561      lum(PA_10,PA_9);
AnalogIn moisture(A3);
Serial sigfox(PB_6, PB_7);
DHT22 Capt_temp_hum(A2);
OneWire OneWire(A4);    // substitute A4 with actual mbed pin name connected to the DS1820 data pin

int main()
{
    oled.initialise();
    oled.clear();
    oled.set_contrast(255); // max contrast
    oled.set_font(bold_font, 8);
    oled.update();
    DeviceAddresses* devAddresses = OneWire.getFoundDevAddresses();
    uint8_t foundNum = OneWire.getFoundDevNum();
    printf("OneWire: found %d devices\r\n", foundNum);
    char _id[16];
    int temp, hum, temp_sol, lumi, moist;
    char a;
    while (1)
    {
        myled = 1; // LED is ON
        //temp = (int) (Capt_temp_hum.getTemperature()/10);
        //hum = (int) (Capt_temp_hum.getHumidity()/10);
        moist = (int) (moisture*100);
        lumi = (int) lum.lux();
        lumi=((lumi & 0xff)<<8) | ((lumi & 0xff00)>>8); //Swipping bytes for Actoboard reception
        OneWireDeviceTemperature::startConversationForAll(&OneWire, OWTEMP_11_BIT);
        for (uint8_t i = 0; i < foundNum; i++) {
            OneWireDevice* owDevice = OneWireDeviceFactory::init(&OneWire, (*devAddresses)[i]);
            
            if (owDevice->getFamily() != ONEWIRE_DS18B20_FAMILY)    // currently only DS18B20 supports
                continue;
 
            owDevice->generateId(_id);
            temp_sol = (int) owDevice->sendGetCommand(GET_TEMPERATURE);
            //oled.printf("OneWire: device #%s = %.4f*C\r\n", _id, (float) owDevice->sendGetCommand(GET_TEMPERATURE));
            delete owDevice;
        }
        a='%';
        //oled.set_font(bold_font, 8);
        //oled.scroll_up();
        //oled.update();
        //Capt_temp_hum.sample();
        //oled.printf("Moisture is %2.2f\r\n", (float) moisture);
        //oled.printf("Lum : %+4.1f lux\r\n", lum.lux());
        //oled.printf("Temp : %d oC\r\n", temp);
        //oled.printf("Humidite : %d%c\r\n", hum, a);
        //oled.printf("Temp sol : %d\r\n", temp_sol);
        //oled.printf("\n");
        sigfox.printf("AT$SF=");
        sigfox.printf("%02x ", temp);
        sigfox.printf("%02x ", hum);
        sigfox.printf("%02x ", temp_sol);
        sigfox.printf("%02x ", moist);
        sigfox.printf("%04x ", lumi);
        sigfox.printf("\r\n");
        wait(15);
        myled = 0; // LED is OFF
        wait(15);
    }
}