/*
#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(SPI_MOSI, SPI_SCK,SPI_CS);  // MOSI, SCLK, CS
//Serial pc(USBTX,USBRX);

#define PI 3.141593

*/
/**** Main Function  ***//*
int main(void)
{
    MCP.frequency(10000000);

    uint16_t i=0;
    uint32_t Freq = 1000;
    uint32_t Fsample=166667;//Sample is 166,667 Hz.
    uint32_t Ampi = 612;
    uint16_t Maxindex; 
    
    Maxindex = (int) (Fsample / Freq);
    if(Maxindex > 800) {
        Fsample = Freq * 800;
        Maxindex = 800;
    }
        
    while(1) {
        MCP.writeA((int)(Ampi * (1+ sin((2*PI*Freq*i)/Fsample))/2));
        i++;
        if(i > Maxindex)
             i=0;   
    }
}
*/
/*
#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(SPI_MOSI, SPI_SCK,SPI_CS);  // MOSI, SCLK, CS

#define PI 3.141593

int main(void)
{
    MCP.frequency(10000000);

    uint16_t i=0;
    uint16_t Ampi=511;
    uint32_t Freq = 1000;

    while(1) {

        MCP.writeA((int)(Ampi * (1+sin((2*PI*Freq*i)/800000))/2));
        //if(i < 0x0FFF)
        if(i < 800)
            i++;
        else
            //i=360;
            //i=90;
            i=0;
        //MCP.writeA((int)(Ampi * sin(2*PI*Freq*i)/2));
        //wait_us(100);
    }
}
*/
/* สรุปแปร๊ป
 ถ้าไม่มี 1+... นี่ กราฟจะเป็น ครึ่งภูเขาผสมกับกราฟขีดขึ้นดิ่งตรง
 ถ้าไม่มี /800000 ที่จริงเป็นเลขอะไรก็ได้ในหลักแสนอ่ะ กราฟจะเป็นแค่ภูเขาหนึ่งลูกเท่านั้น (ครึ่งsin)
 ถ้าไม่มี /2 ตรงยอดกราฟจะเป็นเส้นตรงปาดหน้าภูเขา
 ถ้าไม่มี 1+ กับ /2 ล่ะ เหมือนกราฟแบบข้อแรก
 ถ้าไม่มี /800000 กับ /2 กราฟช่วงแรกโค้ง สักพักเป็นแนวตรง ขาลงก็โค้ง
 ถ้าไม่มี 1+ กับ /800000 กราฟเหมือนข้อสอง
 ถ้าไม่มี 1+ , /800000 , /2 ล่ะ ก็เป็นแค่กราฟภูเขาหนึ่งลูกเอง แถมขีดลงให้ด้วย (ครี่งsin)*/
 
#include "mbed.h"
#include "MCP4922.h"

MCP4922 MCP(SPI_MOSI, SPI_SCK,SPI_CS);  // MOSI, SCLK, CS

#define PI 3.141593

int main(void)
{
    MCP.frequency(100000000);//Frequ 100Mhz
    
    uint16_t i=0;
    uint16_t Ampi=511;

    while(1) {
        for(i=0;i<360;i++){
            MCP.writeA((sin(((i*PI)/180)))*Ampi+2048);
            wait_us(20);         
        }
        
    }
}
