#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

//Serial device(SERIAL_TX, SERIAL_RX);
 
Serial device(D8, D2);

AnalogIn analog_value(A1);

DigitalIn Sw(D3);

BusOut ledSet1(D11, D10, D9, D4); //อย่าลืมกลับเลขด้วยเพราะมันต้องใช้ 7-Segment
BusOut ledSet2(D15, D14, D13, D12); //อย่าลืมกลับเลขด้วยเพราะมันต้องใช้ 7-Se
 
int main(){
    char value[3];
    int index=0;
    uint8_t ch;
    uint8_t state_menu=0;
    ledSet1 = ledSet2 = 0;
    while(1){ 
        if(state_menu == 0) {
            device.printf("Please Input Value Between 0 - 99 OR Select \"a\" To Read Analog Voltage. \n");
            state_menu = 1;
        }     
        do{ 
            ch = device.getc();   // read it
            wait(0.05);//device.printf("        "); // relay time
            if (index<2)               // just to avoid buffer overflow
                value[index++]=ch;  // put it into the value array and increment the index
        } while (index <= 1 && device.readable()==1);    // loop until the '\n' character   
        value[index]='\x0';  // add un 0 to end the c string
        device.printf(" %s \n",value);
        if(strcmp(value,"a")==0){
            float value = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
            value = (value * 3.3); // Change the value to be in the 0 to 3300 range
            device.printf("Status Voltage :: %.2f volte. \n",value);
        }
        else if(( value[0] == '0' || value[0] == '1' || value[0] == '2' || value[0] == '3' || value[0] == '4'|| value[0] == '5' || value[0] == '6' || value[0] == '7'|| value[0] == '8'|| value[0] == '9' )
                && (value[1] == '0' || value[1] == '1' || value[1] == '2' || value[1] == '3' || value[1] == '4'|| value[1] == '5' || value[1] == '6' || value[1] == '7'|| value[1] == '8'|| value[1] == '9' || value[1] == '\x0' )){
            device.printf(" %d is desub.\n",atoi(value)/10);
            device.printf(" %d is Conveart.\n",atoi(value)%10);
            ledSet1 = atoi(value)/10;
            ledSet2 = atoi(value)%10;
        }
        else{
            ledSet1 = ledSet2 = 0;
            device.printf("Cannot is condition.\n\n\n");
        }     
        state_menu=0;
        index=0;    
    }
}