/*
#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

//Serial pc(SERIAL_TX, SERIAL_RX);

Serial device(D8, D2);

AnalogIn analog_value(A1);

DigitalIn Sw(D3);

BusOut ledSet1(D11, D10, D9, D4); //อย่าลืมกลับเลขด้วยเพราะมันต้องใช้ 7-Segment
BusOut ledSet2(D15, D14, D13, D12); //อย่าลืมกลับเลขด้วยเพราะมันต้องใช้ 7-Segment



int main()
{

    uint8_t state_menu=0;
    //uint8_t state_show=0;
    //uint8_t state_exit =0;
    uint8_t data;
    char value[3];
    
    ledSet1 = ledSet2 = 0;
    device.printf("Hello Nucleo !\n");
    while(1) {
                
        if(state_menu == 0) {
            device.printf("Input Value Between 00-99 OR Select a To Read Analog Voltage. \n");
            state_menu = 1;
        }
        if(device.readable()) {
            value[0] = data = device.getc();
            device.printf("\n");
            state_menu=0;
            
            if(data == '0' || data == '1' || data == '2' || data == '3' || data == '4'|| data == '5' || data == '6' || data == '7'|| data == '8'|| data == '9' ){
                //value[0] = data;
                value[1] = device.getc();
                    if(value[1] == '0' || value[1] == '1' || value[1] == '2' || value[1] == '3' || value[1] == '4'|| value[1] == '5' || value[1] == '6' || value[1] == '7'|| value[1] == '8'|| value[1] == '9' ){
                        value[2]='\x0';  // add un 0 to end the c string
                        device.printf("The Number is :: %s !\n",value);
                        device.printf(" %d is desub.\n",atoi(value)/10);
                        device.printf(" %d is Conveart.\n",atoi(value)%10);
                        ledSet1 = atoi(value)/10;
                        ledSet2 = atoi(value)%10;
                    }    
                    else
                        device.printf("plz select Input No 00-99 or a\n\n\n");  
                
            }
            else if(data == 'a'){
                ledSet1 = ledSet2 = 0;
                state_menu=0;
                float value = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
                value = (value * 3300)/1000; // Change the value to be in the 0 to 3300 range
                device.printf("Status Voltage :: %.2f volte. \n",value);
            }
            else
                device.printf("plz select Input No 00-99 or a\n\n\n"); 
            
        }
    }         
  }
*/

#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

//Serial device(SERIAL_TX, SERIAL_RX);

Serial device(D8, D2);

AnalogIn analog_value(A1);

BusOut ledSet1(D11, D10, D9, D4); //อย่าลืมกลับเลขด้วยเพราะมันต้องใช้ 7-Segment
BusOut ledSet2(D15, D14, D13, D12); //อย่าลืมกลับเลขด้วยเพราะมันต้องใช้ 7-Segment

Timer t;

int main()
{

    uint8_t state_menu=0;
    char data[3]={"\x0"};
    int i=0;

    ledSet1 = ledSet2 = 0;
    while(1) {
        t.reset();
        t.start();
        i=0;
        if(state_menu == 0) {
            device.printf("Input Value Between 00-99 OR Select a To Read Analog Voltage. \n");
            state_menu = 1;
        }
        while(i<2){
            if(t.read_ms() < 1200){
                if (device.readable()) {
                    data[i] = device.getc();
                    i++;
                }
            }
            else 
                break;
        }
        data[++i]='\0';  // add un 0 to end the c string
        if(strlen(data)==0){
            float value = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
            value = (value * 3.3); // Change the value to be in the 0 to 3300 range
            device.printf("Status Voltage :: %.2f volte. \n",value);
        }
        else if(( data[0] == '0' || data[0] == '1' || data[0] == '2' || data[0] == '3' || data[0] == '4'|| data[0] == '5' || data[0] == '6' || data[0] == '7'|| data[0] == '8'|| data[0] == '9' )
                && (data[1] == '0' || data[1] == '1' || data[1] == '2' || data[1] == '3' || data[1] == '4'|| data[1] == '5' || data[1] == '6' || data[1] == '7'|| data[1] == '8'|| data[1] == '9' || data[1] == '\x0' )){
            device.printf("The Number is :: %d !\n",atoi(data));
            ledSet1 = atoi(data)/10;
            ledSet2 = atoi(data)%10;    
        }
        else{
            ledSet1 = ledSet2 = 0;
            device.printf("Cannot is condition.\n\n\n");
        }     
        state_menu=0;
        strcpy(data,"\x0");   
    }
  }

