#include "ArduinoMotorShield.h"
#include "mbed.h"

//Timer for measure time between steps
Timer timer;

//Ticker for running at a specified speed
Ticker runTick;

/*
 *   constructor for four-pin version
 *   Sets which wires should control the motor.
 */
ArduinoMotorShield::ArduinoMotorShield(int numberOfSteps, PinName brakeA, PinName brakeB, PinName dirA, PinName dirB, PinName pvmA, PinName pvmB) : _BRAKEA(brakeA),_BRAKEB(brakeB),_DIRA(dirA),_DIRB(dirB),_ENA_A(pvmA),_ENA_B(pvmB)
{
  this->step_number = 0;      // which step the motor is on
  this->speed = 0;        // the motor speed, in revolutions per minute
  this->direction = 0;      // motor direction
  this->last_step_time = 0;    // time stamp in ms of the last step taken
  this->number_of_steps = numberOfSteps;    // total number of steps for this motor


  this->_ENA_A = 1; //TODO: move. For enable the L298 in stepper mode
  this->_ENA_B = 1; //TODO: move. For enable the L298 in stepper mode

}


void ArduinoMotorShield::setStepperSpeed(long whatSpeed)
{
  this->step_delay = 60L * 1000L / this->number_of_steps / whatSpeed;
}


void ArduinoMotorShield::step(int numberOfSteps)
{
  timer.start();
  int steps_left = abs(numberOfSteps);  // how many steps to take

  // determine direction based on whether steps_to_mode is + or -:
  if (numberOfSteps > 0) {this->direction = 1;}
  if (numberOfSteps < 0) {this->direction = 0;}


  // decrement the number of steps, moving one step each time:
  while(steps_left > 0) {
  // move only if the appropriate delay has passed:
  if (timer.read_ms() - this->last_step_time >= this->step_delay) {
      // get the timeStamp of when you stepped:
      this->last_step_time = timer.read_ms();
      // increment or decrement the step number,
      // depending on direction:
      if (this->direction == 1) {
        this->step_number++;
        if (this->step_number == this->number_of_steps) {
          this->step_number = 0;
        }
      }
      else {
        if (this->step_number == 0) {
          this->step_number = this->number_of_steps;
        }
        this->step_number--;
      }
      // decrement the steps left:
      steps_left--;
      // step the motor to step number 0, 1, 2, or 3:
      stepMotor(this->step_number % 4);
    }
  }
}

// tick event handler for running the motor at a specified speed
void ArduinoMotorShield::runMotor(void)
{
    // increment or decrement the step number,
      // depending on direction:
      if (this->direction == 1) {
        this->step_number++;
        if (this->step_number == this->number_of_steps) {
          this->step_number = 0;
        }
      }
      else {
        if (this->step_number == 0) {
          this->step_number = this->number_of_steps;
        }
        this->step_number--;
      }

      // step the motor to step number 0, 1, 2, or 3:
      stepMotor(this->step_number % 4);
}

// Run at a specified speed, no blocking
void ArduinoMotorShield::runStepperAtSpeed(bool startStop, int whatSpeed, int direction)
{
    this->direction = direction;
    if(whatSpeed != 0)
    {
        this->step_delay = 60L * 1000L / this->number_of_steps / whatSpeed;
    }
    else
    {
        this->step_delay = 60L * 1000L / this->number_of_steps / 1;
    }

    if(startStop)
    {
        this->_ENA_A = 1; //TODO: move. For enable the L298 in stepper mode
        this->_ENA_B = 1; //TODO: move. For enable the L298 in stepper mode
        runTick.attach_us(this, &ArduinoMotorShield::runMotor, step_delay*1000); // the address of the function to be attached
    }
    else
    {
        runTick.detach();
        _BRAKEA = 0;
        _BRAKEB = 0;
        _DIRA = 0;
        _DIRB = 0;
        _ENA_A = 0;
        _ENA_B = 0;
    }
}

/*
 * Moves the motor forward or backwards.
 */
void ArduinoMotorShield::stepMotor(int thisStep)
{
  switch (thisStep) {
      case 0:    // 1010
          _BRAKEA = 0;  // brake A
          _BRAKEB = 0;  // brake B
          _DIRA = 1;
          _DIRB = 1;
      break;
      case 1:    // 0110
          _BRAKEA = 0;  // brake A
          _BRAKEB = 0;  // brake B
          _DIRA = 0;
          _DIRB = 1;
      break;
      case 2:    //0101
          _BRAKEA = 0;  // brake A
          _BRAKEB = 0;  // brake B
          _DIRA = 0;
          _DIRB = 0;
      break;
      case 3:    //1001
          _BRAKEA = 0;  // brake A
          _BRAKEB = 0;  // brake B
          _DIRA = 1;
          _DIRB = 0;
      break;
    }
 }






