
#include "mbed.h"

enum State {READ_INPUT, WRITE_DISTANCE} state = READ_INPUT;

Ticker timer;
DigitalIn push_button(D15);
InterruptIn reset_button(USER_BUTTON);
PwmOut LED(D3);
AnalogIn Distance(PA_1);

Serial pc(USBTX, USBRX);

void reset()
{
    state = READ_INPUT;
}

int main()
{
    LED = 0;
    int a=0;
    reset_button.rise(&reset);
    enum State next_state = state;

    while(1) {
        switch(next_state) {
            case READ_INPUT:

                LED=Distance.read();
                if(push_button == 1) {
                    next_state = WRITE_DISTANCE;

                }
                break;

            case WRITE_DISTANCE:
                while (a<1) {
                    pc.printf("De afstand is cm :%f\n\r",(1-Distance.read())*18);
                    a++;
                }
                break;

        }
    }
}
