/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "QEI.h"
Serial pc(USBTX, USBRX, 115200);
Serial md(PC_10, PC_11, 38400);
// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500
#define ROTATE_PER_REVOLUTIONS 64    //For QEI's pulse data
int r;
bool kai=0;
DigitalIn btn(USER_BUTTON);
DigitalOut led(LED2);
void moter(int x){
    r = x+128;
    md.putc(r);
     pc.printf("%d\n",r);
}
int main()
{   
    md.format(8,Serial::None,1);
    moter(0);
    while(!btn){
        led=!led;
        wait(0.05);
    }
    led=1;
    while(btn){}
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
 QEI wheel(PC_8, PC_9, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
    while(1){
        pc.printf("c");
        pc.printf("%d",kai);
        pc.printf("Pulses: %07d", wheel.getPulses());
        pc.printf("Rotate: %d\n", (int)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4));
        if((int)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4)<10&&kai==0){
            moter(48);
            pc.printf("a");
            if((int)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4)==9){
            kai=1;
            }
        }
        if((int)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4)>0&&kai==1){
            moter(-48);
            pc.printf("b");
            if((int)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4)==1){
            kai=0;
            }
        }
    //    moter(0);
    }
}