#include "mbed.h"

DigitalOut myled(A0);
BusOut Seg1(D2,D3,D4,D5,D6,D7,D8); // A,B,C,D,E,F,G,DP
BusOut Seg2(D9,D10,D11,D12,D13,D14,D15); // A,B,C,D,E,F,G,DP

char SegConvert(char SegValue); // function prototype

int main() { // main program
while (1) { // infinite loop
    for (char j=9;j>0;j--) { // counter loop 1
        
        Seg1=SegConvert(j); // tens column
        
        for (char i=9;i>0;i--) { // counter loop 2
            
            Seg2=SegConvert(i); // units column
            
            myled = 0;
            
            if( ( (10*j)+ i)%7==0 ){ //checks current number is divisible by 7
                myled = 1;
                
                }
            wait(0.5);
            
            }
        }
        
}// end of while

}// end of main

char SegConvert(char SegValue) { // function 'SegConvert'
    
    char SegByte=0x00;
    switch (SegValue) { // DP G F E D C B A
    case 0: SegByte = 0xC0; break; //display 0   1 1 0 0  0 0 0 0
    case 1: SegByte = 0xF9; break; //display 1   1 1 1 1  1 0 0 1
    case 2: SegByte = 0xA4; break; //display 2   1 0 1 0  0 1 0 0
    case 3: SegByte = 0xB0; break; //display 3   1 0 1 1  0 0 0 0
    case 4: SegByte = 0x99; break; //display 4   1 0 0 1  1 0 0 1
    case 5: SegByte = 0x92; break; //display 5   1 0 0 1  0 0 1 0
    case 6: SegByte = 0x82; break; //display 6   1 0 0 0  0 0 1 0
    case 7: SegByte = 0xF8; break; //display 7   1 1 1 1  1 0 0 0
    case 8: SegByte = 0x80; break; //display 8   1 0 0 0  0 0 0 0
    case 9: SegByte = 0x90; break; //display 9   1 0 0 1  0 0 0 0
    
    }

    return SegByte;

}