#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

PwmOut blue(D2);
PwmOut green(D3);
PwmOut red(D4);

#define RED 0
#define GREEN 2
#define BLUE 1

volatile bool fade = false;

volatile float amnt = 1;

void handle_input(){
    
    //if(pc.readable()){
    char input = pc.getc();
    
    // on/off
    if(input == '1'){
        pc.printf("On/Off 1 Sec Cycle!\n");
        fade = false;
    }
    
    // fade
    else if(input == '2'){
        pc.printf("Fade On/Off 1 sec cycle!\n");
        fade = true;
    }


}

int main() {
    
    // set the     
    blue.period_ms(10);
    green.period_ms(10);
    red.period_ms(10);
    
    while(1){
        
        
        if(pc.readable()){
            handle_input();
            
            red = 1;
            green.pulsewidth_us((int)(amnt*100));
            blue = 1;
            
        }
        
    }
}
