// A solution to OCE360 Homework #4.
// Objective: Use object oriented programming to create a system that displays
// multiple balls bouncing around the LCD screen.
// Stephen Licht, 11/7/2017

#include "mbed.h"
#include "MMA8452Q.h"           //acceleromater library
#include "uLCD_4DGL.h"          //LCD library
#include "bouncing_ball.h"      //new ball phyics library

#define UPDATE_TIME_S 0.02
#define START_X_1 10
#define START_Y_1 10
#define START_X_2 20
#define START_Y_2 20
#define RADIUS_1 6
#define RADIUS_2 3

#define DEBUG_MODE 0

//Function prototype for color selection function:
int get_LCD_color(int color_integer);

// Graphic LCD - TX, RX, and RES pins
uLCD_4DGL uLCD(p9,p10,p11);     //initialize a driver object for an LCD connected on pins 9-11

// Accelerometer - SDA, SCL, and I2C address
MMA8452Q accel(p28, p27, 0x1D);  //initialize a driver object for an accelerometer connected on pins 27-28.

physics_ball ball1;  //initialize two balls for bouncing
physics_ball ball2;  //the default states from the library will be used initially

int main()
{
    // Initialize uLCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();

    // Initialize accelerometer
    accel.init();

    //Initialize balls:
    ball1.set_state(START_X_1,START_Y_1,0,0); //speeds are set to zero
    ball1.set_state(START_X_2,START_Y_2,0,0);

    //Set ball radius and color:
    ball1.set_param(RADIUS_1,0); //color is unimportant
    ball2.set_param(RADIUS_2,1); //just making sure the colors are different

    /* Make the balls "fall" in direction of accelerometer by forcing the ball objects
     to update themselves at regular intervals, and te drawing the locations reported
     by the ball objects on the LCD screen: */
    while (1) {  //execute 'forever'
        // Draw circles in the x and y positions stored by the ball objects:
        uLCD.filled_circle(ball1.posx, ball1.posy, ball1.radius, get_LCD_color(ball1.color));
        uLCD.filled_circle(ball2.posx, ball2.posy, ball2.radius, get_LCD_color(ball2.color));

        // Wait before erasing old circles:
        wait(UPDATE_TIME_S);         // In seconds

        // Erase old circles by writing over there locations using the screen color:
        uLCD.filled_circle(ball1.posx, ball1.posy, ball1.radius, BLACK);
        uLCD.filled_circle(ball2.posx, ball2.posy, ball2.radius, BLACK);

        // Force the objects 'ball1' and 'ball2' to update their stored positions
        // and velocities:
        ball1.update(UPDATE_TIME_S,accel);
        ball2.update(UPDATE_TIME_S,accel);

        if (DEBUG_MODE) {
            //If compiled with DEBUG_MODE flag raised, print values to screen.
            uLCD.locate(0,4);
            uLCD.printf("X: %d.1\nY: %.1d",ball1.posx,ball1.posy);

            uLCD.locate(0,6);
            uLCD.printf("VX: %f.1\nVY: %.1f",ball1.speedx,ball1.speedy);

            uLCD.locate(0,10);
            uLCD.printf("AX: %f.1\nAY: %.1f\nAZ: %0.1f",accel.readX(),accel.readY(),accel.readZ());
        }
    }
}

//Interpret LCD colors.
int get_LCD_color(int color_integer)
{
    switch (color_integer) {
        case 0:
            return(RED);
        case 1:
            return(BLUE);
        case 2:
            return(GREEN);
        default:
            return(WHITE);
    }
}