# Pelion Device Management Client example for Mbed OS

This is clone of https://github.com/ARMmbed/mbed-os-example-pelion and focuses on Nuvoton targets.

## Support targets

Platform                        |  Connectivity     | Storage for credentials and FW candidate  | Notes
--------------------------------|-------------------|-------------------------------------------|---------------
Nuvoton NUMAKER_PFM_NUC472      | Ethernet          | NU SD card                                |
Nuvoton NUMAKER_PFM_M487        | Ethernet          | NU SD card                                |
Nuvoton NUMAKER_IOT_M487        | Wi-Fi ESP8266     | NU SD card                                |                              |
Nuvoton NUMAKER_IOT_M263A       | Wi-Fi ESP8266     | NU SD card                                |
Nuvoton NU_PFM_M2351_NPSA_NS    | Wi-Fi ESP8266     | NU SD card                                |

**Note1**: M2351 is not supported on Mbed Online Compiler. Use Mbed CLI instead. Besides, its support is limited to specific version (7bfbb8e70559), not the latest version.
This is because Mbed OS [doesn't support Armv8M secure code build since 6.0.0-beta-1](https://github.com/ARMmbed/mbed-os/pull/12737).

## Known issues

-   Meet error with `fcc_init() failed with 1`

    ```
    The device has not provisioned yet. Try to provision it...
    Provision for development...
    Reset kvstore...
    Reset kvstore...OK
    Provision for development...OK
    Application ready
    Connect to network
    Network initialized, connected with IP 192.168.8.101

    Start developer flow
    fcc_init() failed with 1
    ```

    When the error happens, it is possibly caused by [incorrect check with non-default configuration of FLASHIAP](https://github.com/ARMmbed/mbed-os/pull/12808).
    Mbed OS 5.15.2, 5.15.3, 6.0.0 alpha, and 6.0.0 beta all suffer from this.
    Use Mbed OS 5.15.1 instead to avoid this error.