# Getting started with bootloader on mbed OS

This example is a clone of [mbed-os-example-bootloader](https://github.com/ARMmbed/mbed-os-example-bootloader)
with SD card in SPI mode replaced with SD mode.
For bootloader flow details, please refer to the [original](https://github.com/ARMmbed/mbed-os-example-bootloader) one.

## Supported platforms
- [NuMaker-PFM-NUC472](https://developer.mbed.org/platforms/Nuvoton-NUC472/)
- [NuMaker-PFM-M487](https://developer.mbed.org/platforms/NUMAKER-PFM-M487/)

For targets which don't support SD card in SD mode, please refer back to the [original](https://github.com/ARMmbed/mbed-os-example-bootloader) one.
- [NuMaker-PFM-M453](https://developer.mbed.org/platforms/Nuvoton-M453/)
- [NuMaker-PFM-NANO130](https://os.mbed.com/platforms/NUMAKER-PFM-NANO130/)

## Configuration for a new target
To support a new target, we need to modify `mbed_app.json` for the new target:
1. Specify bootloader image size after padding. Here it is 0x20000 for both **NUMAKER_FPM_NUC472** and **NUMAKER_FPM_M487**.
1. Specify application image name which would be saved in SD card.
   Same as the [original](https://github.com/ARMmbed/mbed-os-example-bootloader) one,
   the application image is built from [mbed-os-example-bootloader-blinky](https://github.com/ARMmbed/mbed-os-example-bootloader-blinky).
1. The SPI pins `sd_card_mosi`/`sd_card_miso`/`sd_card_sck`/`sd_card_cs` are for SD card in SPI mode.
   They are for information and are not used here. 
```
        "NUMAKER_PFM_NUC472": {
            "target.restrict_size": "0x20000",
            "update_file": "\"mbed-os-example-bootloader-blinky_application.bin\"",
            "sd_card_mosi": "PF_0",
            "sd_card_miso": "PD_15",
            "sd_card_sck":  "PD_14",
            "sd_card_cs":   "PD_13"
        },
        "NUMAKER_PFM_M487": {
            "target.restrict_size": "0x20000",
            "update_file": "\"mbed-os-example-bootloader-blinky_application.bin\"",
            "sd_card_mosi": "D11",
            "sd_card_miso": "D12",
            "sd_card_sck":  "D13",
            "sd_card_cs":   "D10"
        }
```

## SD card in SD mode
In `main.cpp`, include header file for block device of SD card in SD mode:
```
#include "mbed.h"
#if defined(TARGET_NUMAKER_PFM_NUC472) || defined(TARGET_NUMAKER_PFM_M487)
#include "NuSDBlockDevice.h"
#else
#include "SDBlockDevice.h"
#endif
#include "FATFileSystem.h"
```
In `main.cpp`, instantiate block device of SD card in SD mode:
```
#if defined(TARGET_NUMAKER_PFM_NUC472) || defined(TARGET_NUMAKER_PFM_M487)
NuSDBlockDevice sd;
#else
//Pin order: MOSI, MISO, SCK, CS
SDBlockDevice sd(MBED_CONF_APP_SD_CARD_MOSI, MBED_CONF_APP_SD_CARD_MISO,
                 MBED_CONF_APP_SD_CARD_SCK, MBED_CONF_APP_SD_CARD_CS);
#endif
```