// NuMaker-PFM-NUC472 : I2C LCD+IMU control the direction of moving pointer
#include "mbed.h"
#include "math.h"
#include "mpu6500.h"
#include "ssd1306.h"
#include "draw2D.h"

#define PI 3.1415926535

#define X0 64       // initial point
#define Y0 32       // initial point

I2C i2c0(PC_9 , PA_15); // I2C0_SDA, I2C0_SCL
I2C i2c1(PD_12, PD_10); // I2C1_SDA, I2C1_SCL

MPU6500 IMU; // IMU connected on I2C0 (on-board MPU6500)
SSD1306 LCD; // LCD connected on I2C1
Draw2D  D2D;  // Draw2D library

int main() {
    int   accX, accY, accZ;
    float theta, psi;

    int dirX, dirY;
    int movX, movY;
    int x, y, r;
    
    i2c0.frequency(400000);
    i2c1.frequency(400000); 
    
    IMU.initialize();
    LCD.initialize();
    LCD.clearscreen();

    x = X0;    // cross center x
    y = Y0;    // cross center y
    r = 2;     // cross length
    
    movX = 2;  // x movement
    movY = 2;  // y movement
    dirX = 1;  // x direction
    dirY = 1;  // y direction
         
    while(true) {
       D2D.drawLine(x-2, y, x+2, y, FG_COLOR, BG_COLOR); // draw a line
       D2D.drawLine(x, y-2, x, y+2, FG_COLOR, BG_COLOR); // draw a line
                            
       Thread::wait(10);
       
       D2D.drawLine(x-2, y, x+2, y, BG_COLOR, BG_COLOR); // draw a line
       D2D.drawLine(x, y-2, x, y+2, BG_COLOR, BG_COLOR); // draw a line

       // read Accelerometer to calculate tilt angle
       accX = IMU.getAccelXvalue();
       accY = IMU.getAccelYvalue();
       accZ = IMU.getAccelZvalue();
       theta = atan(accX / sqrt(pow(accY,2.0) + pow(accZ,2.0))) *180 /PI;
       psi   = atan(accY / sqrt(pow(accZ,2.0) + pow(accX,2.0))) *180 /PI;          
              
       if      (theta<-20) dirX= 1;
       else if (theta> 20) dirX=-1;
       else                dirX= 0;
       if      (psi  <-20) dirY= 1;
       else if (psi  > 20) dirY=-1;
       else                dirY= 0;       
             
       x = x + dirX * movX; // change x of circle center
       y = y + dirY * movY; // change y of circle center

       // boundary check for changing direction       
       if      ((x-r) <=0)        {dirX= 1; x= x + dirX*movX;}
       else if ((x+r) >=LCD_Xmax) {dirX=-1; x= x + dirX*movX;}
       
       if      ((y-r) <=0)        {dirY= 1; y= y + dirY*movY;}
       else if ((y+r) >=LCD_Ymax) {dirY=-1; y= y + dirY*movY;}
   }       
}
